from flask import Flask, render_template
import psycopg2
import psycopg2.extras

app = Flask(__name__)

@app.route("/", methods=['GET'])
def homepage():

    with psycopg2.connect("dbname='visage' host='localhost'") as conn:

        cur = conn.cursor(cursor_factory=psycopg2.extras.RealDictCursor)

        #  Most recent public company blog post.
        cur.execute("""
            SELECT post_id, post_title,
                LEFT(post_text, 100) AS post_text_short
            FROM post JOIN "user" USING (user_id)
            WHERE user_type_id = 1
            ORDER BY updated_at DESC LIMIT 1
        """)
        latest_blog_post = cur.fetchone()

        # A count of recently active users.
        cur.execute("""
            SELECT COUNT(DISTINCT user_id) AS count
            FROM (
                SELECT user_id FROM comment
                WHERE created_at > NOW() - INTERVAL '1' DAY
                UNION
                SELECT user_id FROM post
                WHERE updated_at > NOW() - INTERVAL '1' DAY
            ) AS u;
        """)
        recent_user_count = cur.fetchone()

        #  Four of the latest posts.
        cur.execute("""
            SELECT post_id, post_title,
                LEFT(post_text, 100) AS post_text_short
            FROM post
            ORDER BY updated_at DESC LIMIT 4
        """)
        recent_posts = cur.fetchall()

    return render_template('home.html',
                           latest_blog_post=latest_blog_post,
                           recent_user_count=recent_user_count,
                           recent_posts=recent_posts)

if __name__ == '__main__':
    app.run()
