#!python

import psycopg2
import redis

with psycopg2.connect("dbname='visage' host='localhost'") as conn:

    with conn.cursor() as cur:

        cur.execute("""
            SELECT COUNT(DISTINCT user_id) AS count
            FROM (
                SELECT user_id FROM comment
                WHERE created_at > NOW() - INTERVAL '1' DAY
                UNION
                SELECT user_id FROM post
                WHERE updated_at > NOW() - INTERVAL '1' DAY
            ) AS u;
        """)
        recent_user_count = cur.fetchone()[0]

        with redis.Redis() as cache:
            cache.set("recent_user_count", recent_user_count)
