ALTER TABLE post ADD COLUMN IF NOT EXISTS avg_rating NUMERIC(2,1);

WITH r(post_id, avg_rating) AS (
  SELECT post_id, AVG(rating)
  FROM rating
  GROUP BY post_id)
UPDATE post
SET avg_rating = r.avg_rating
FROM r
WHERE post.post_id = r.post_id;

DROP TRIGGER IF EXISTS trig_avg_rating ON rating;

-- START:trigger
CREATE OR REPLACE FUNCTION func_avg_rating()
  RETURNS TRIGGER AS $$
DECLARE
  new_post_id BIGINT := 0;
  old_post_id BIGINT := 0;
BEGIN

  IF (TG_OP IN ('INSERT', 'UPDATE')) THEN
    new_post_id := NEW.post_id;
  END IF;
  IF (TG_OP IN ('UPDATE', 'DELETE')) THEN
    old_post_id := OLD.post_id;
  END IF;

  WITH r(post_id, avg_rating) AS (
    SELECT post_id, AVG(rating)
    FROM rating
    WHERE post_id IN (new_post_id, old_post_id)
    GROUP BY post_id)
  UPDATE post
  SET avg_rating = r.avg_rating
  FROM r
  WHERE post.post_id = r.post_id;

  RETURN NEW;
END;
$$ LANGUAGE PLPGSQL;

CREATE TRIGGER trig_avg_rating
  AFTER INSERT OR UPDATE OR DELETE ON rating
FOR EACH ROW
  EXECUTE FUNCTION func_avg_rating();
-- END:trigger

START TRANSACTION;

-- START:query1
SELECT post_id, avg_rating FROM post
WHERE post_id = 1234;
-- END:query1
-- START:query2
INSERT INTO rating (post_id, user_id, rating) VALUES (1234, 5, 5.0);

SELECT post_id, avg_rating FROM post
WHERE post_id = 1234;
-- END:query2
-- START:query3
DELETE FROM rating
WHERE post_id = 1234 AND user_id = 3;

SELECT post_id, avg_rating FROM post
WHERE post_id = 1234;
-- END:query3

ROLLBACK;
