ALTER TABLE post ADD COLUMN IF NOT EXISTS author_display_name VARCHAR(64);

UPDATE post
SET author_display_name = display_name
FROM "user"
WHERE post.user_id = "user".user_id;

DROP TRIGGER IF EXISTS trig_denorm_user_name ON "user";

-- START:trigger
CREATE OR REPLACE FUNCTION upd_denorm_user_name()
  RETURNS TRIGGER AS $$
BEGIN
  UPDATE post
  SET author_display_name = NEW.display_name
  WHERE user_id = NEW.user_id;

  RETURN NEW;
END;
$$ LANGUAGE PLPGSQL;

CREATE TRIGGER trig_denorm_user_name
  AFTER UPDATE ON "user"
FOR EACH ROW
  EXECUTE FUNCTION upd_denorm_user_name();
-- END:trigger

START TRANSACTION;

-- START:query1
SELECT post_id, user_id, author_display_name FROM post
WHERE user_id = 3;
-- END:query1
-- START:query2
UPDATE "user"
SET display_name = 'julius'
WHERE user_id = 3;

SELECT post_id, user_id, author_display_name FROM post
WHERE user_id = 3;
-- END:query2

ROLLBACK;
