-- Visage, a social media app

DROP TABLE IF EXISTS comment, post, post_tag, rating, revision, tag, "user", user_type;

-- START:create
CREATE TABLE user_type (
  user_type_id SMALLSERIAL PRIMARY KEY,
  user_type VARCHAR(16) NOT NULL
);

CREATE TABLE "user" (
  user_id BIGSERIAL PRIMARY KEY,
  user_type_id SMALLINT NOT NULL REFERENCES user_type,
  display_name VARCHAR(64) NOT NULL,
  real_name VARCHAR(64) NOT NULL,
  thumbnail BYTEA,
  contact_email VARCHAR(64) NOT NULL,
  contact_phone VARCHAR(64) NOT NULL,
  birth_date DATE
);

CREATE TABLE tag (
  tag_id SERIAL PRIMARY KEY,
  tag TEXT NOT NULL
);

CREATE TABLE post (
  post_id BIGSERIAL PRIMARY KEY,
  post_title TEXT NOT NULL,
  post_text TEXT NOT NULL,
  user_id BIGINT NOT NULL REFERENCES "user",
  view_count BIGINT NOT NULL DEFAULT 0,
  created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  notified_at TIMESTAMP NULL
);

CREATE TABLE post_tag (
  post_id BIGINT REFERENCES post,
  tag_id INT REFERENCES TAG,
  PRIMARY KEY (post_id, tag_id)
);

CREATE TABLE comment (
  comment_id BIGSERIAL PRIMARY KEY,
  post_id BIGINT NOT NULL REFERENCES post,
  comment_text TEXT NOT NULL,
  in_reply_to BIGINT REFERENCES comment,
  user_id BIGINT NOT NULL REFERENCES "user",
  created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  notified_at TIMESTAMP NULL
);

CREATE TABLE rating (
  post_id BIGINT REFERENCES post,
  user_id BIGINT REFERENCES "user",
  rating NUMERIC NOT NULL CHECK (rating BETWEEN 0 AND 5),
  PRIMARY KEY (post_id, user_id)
);
-- END:create

INSERT INTO user_type (user_type_id, user_type)
VALUES
  (1, 'admin'),
  (2, 'user');

INSERT INTO "user" (user_id, user_type_id, display_name, real_name, contact_email, contact_phone, birth_date)
VALUES
  (1, 1, 'bud', 'Bud Abbott', 'bud@visage.example', '818-555-1111', '1897-10-02'),
  (2, 2, 'lou', 'Lou Costello', 'lou@visage.example', '818-555-2222', '1906-03-06'),
  (3, 2, 'groucho', 'Groucho Marx', 'groucho@visage.example', '818-555-3333', '1890-10-02'),
  (4, 2, 'chico', 'Chico Marx', 'chico@visage.example', '818-555-3333', '1887-03-22'),
  (5, 2, 'harpo', 'Harpo Marx', 'harpo@visage.example', '818-555-3333', '1888-11-23');

INSERT INTO post (post_id, post_title, post_text, user_id, view_count)
VALUES
  (1234, 'Who''s On First?', 'Well Costello, I’m going to New York with you. You know Bookie Harris, the Yankee’s manager, gave me a job as coach for as long as you’re on the team.', 1, 2902909),
  (5678, 'Horse Feathers Password Scene', 'Watch the door for a few minutes. And don''t let anyone in without the password.', 4, 1526278),
  (9012, 'Duck Soup Mirror Scene', '<Physical comedy in silence.>', 5, 1384194);

INSERT INTO comment (comment_id, post_id, comment_text, in_reply_to, user_id)
VALUES
  (1, 1234, 'Well, let''s see, we have on the St Louis team, Who''s on first, What''s on second, I Don''t Know is on third…', null, 1),
  (2, 1234, 'That''s what I want to find out.', 1, 2),
  (3, 1234, 'I say Who''s on first, What''s on second, I Don''t Know''s on third.', 2, 1),
  (4, 1234, 'Are you the manager?', 3, 2),
  (5, 1234, 'Yes.', 4, 1),
  (6, 1234, 'You gonna be the coach too?', 5, 2),
  (7, 1234, 'Yes.', 6, 1),
  (8, 1234, 'And you don''t know the fellows'' names?', 7, 2),
  (9, 1234, 'Well I should.', 8, 1),
  (10, 1234, 'Well then who''s on first?', 9, 2),
  (11, 1234, 'Yes.', 10, 1);

INSERT INTO tag (tag_id, tag)
VALUES
  (1, 'tag1'),
  (2, 'tag2'),
  (3, 'tag3'),
  (4, 'tag4'),
  (5, 'tag5');

INSERT INTO post_tag (post_id, tag_id)
VALUES
  (1234, 1),
  (1234, 2),
  (1234, 3),
  (5678, 1),
  (5678, 3),
  (5678, 4),
  (9012, 2),
  (9012, 3),
  (9012, 5);

INSERT INTO rating(post_id, user_id, rating)
VALUES
  (1234, 3, 2),
  (1234, 4, 4);
