import psycopg2
import psycopg2.extras

conn = psycopg2.connect("dbname='visage' host='localhost'")

with conn.cursor(cursor_factory=psycopg2.extras.RealDictCursor) as cur:

    users = dict()
    cur.execute("""
        SELECT user_id, display_name
        FROM "user"
        """)

    # Transform result into dict, keyed by user_id.
    # The Java developer in the story implemented this
    # by coding a B-tree from scratch.
    for row in cur:
        user_id = row['user_id']
        users[user_id] = row

    cur.execute("""
        SELECT comment_id, comment_text, in_reply_to,
            user_id, created_at
        FROM comment
        """)
    comments = cur.fetchall()

# Match rows from each set together, and make combined rows.
for comment in comments:
    if comment['user_id'] in users:
        user = users[comment['user_id']]
        comment.update(user)

print(comments)
