import psycopg2
import psycopg2.extras

# Pretend these are two different database servers.
conn1 = psycopg2.connect("dbname='visage' host='localhost'")
conn2 = psycopg2.connect("dbname='visage' host='localhost'")

cur1 = conn1.cursor(cursor_factory=psycopg2.extras.RealDictCursor)
cur2 = conn2.cursor(cursor_factory=psycopg2.extras.RealDictCursor)

cur1.execute("""
    SELECT user_id, display_name
    FROM "user"
    ORDER BY user_id
    """)

cur2.execute("""
    SELECT comment_id, comment_text, in_reply_to,
        user_id, created_at
    FROM comment
    ORDER BY user_id
    """)

# Initial user dict has a user_id 0, which is a number
# but does not match any user_id referenced by any comment.
user = {"user_id": 0}

for comment in cur2:
    # Skip over users until the cursor reaches a user that matches
    # the current comment.
    while (user["user_id"] < comment["user_id"]):
        user = cur1.fetchone()
    comment.update(user)
    print(comment)
