-- START:alter
ALTER TABLE "user"
  ADD COLUMN IF NOT EXISTS properties JSONB;
-- END:alter

-- START:update
UPDATE "user"
SET properties = '{
    "haircolor": "blonde",
    "birthday": "November 23",
    "hobby": "harpist"
  }'
WHERE user_id = 5;

UPDATE "user"
SET properties = '{
    "haircolo": "black",
    "birthday": "October 2",
    "alias": "Rufus T. Firefly"
  }'
WHERE user_id = 3;
-- END:update

-- START:query1
SELECT u.user_id, u.real_name, j.* FROM "user" AS u
CROSS JOIN jsonb_each_text(properties) j(key, value)
WHERE u.user_id IN (3, 5);
-- END:query1

DROP TYPE IF EXISTS myrowtype;
-- START:query2
CREATE TYPE myrowtype AS (hobby TEXT, birthday TEXT,
  haircolor TEXT, alias TEXT);

SELECT u.user_id, u.real_name, j.* FROM "user" AS u
CROSS JOIN jsonb_populate_record(null::myrowtype, properties) j
WHERE u.user_id IN (3, 5);
-- END:query2
