import psycopg2

conn = psycopg2.connect("dbname='visage' host='localhost'")

with conn.cursor() as cur:

    cur.execute("""
      SELECT post_id, created_at
      FROM post
      WHERE post_id = %(post_id)s
        AND created_at < '2021-06-14'
      UNION
      SELECT post_id, (metadata->>'created_at')::timestamp AS created_at
      FROM post
      WHERE post_id = %(post_id)s
        AND created_at BETWEEN '2021-06-14' AND '2021-07-02'
      UNION
      SELECT post_id, (metadata->>'date_created')::timestamp AS created_at
      FROM post
      WHERE post_id = %(post_id)s
        AND created_at > '2021-07-02' OR created_at IS NULL
    """, {'post_id': 1234})

    print(cur.fetchall())
