DROP TABLE IF EXISTS post_size_test_1, post_size_test_2, post_size_test_3, post_size_test_4;

-- START:create
CREATE TABLE post_size_test_1 (
  post_id BIGSERIAL PRIMARY KEY,
  post_title TEXT NOT NULL,
  post_text TEXT NOT NULL,
  user_id BIGINT NOT NULL DEFAULT 0,
  created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE post_size_test_2 (
  post_id BIGSERIAL PRIMARY KEY,
  attributes JSON
);

CREATE TABLE post_size_test_3 (
  post_id BIGSERIAL PRIMARY KEY,
  attributes JSONB
);

CREATE TABLE post_size_test_4 (
  post_id BIGSERIAL PRIMARY KEY,
  attributes JSONB
);
-- END:create

-- START:insert1
INSERT INTO post_size_test_1 (post_title, post_text)
  SELECT
    RPAD(GENERATE_SERIES::VARCHAR, 40, MD5(RANDOM()::TEXT)) AS post_title,
    RPAD(GENERATE_SERIES::VARCHAR, 16*1024, MD5(RANDOM()::TEXT)) AS post_text
  FROM GENERATE_SERIES(1, 1000000);
-- END:insert1

-- START:insert23
INSERT INTO post_size_test_2 (post_id, attributes)
  SELECT post_id, TO_JSONB(p) - 'post_id' FROM post_size_test_1 AS p;

INSERT INTO post_size_test_3 (post_id, attributes)
  SELECT post_id, TO_JSONB(p) - 'post_id' FROM post_size_test_1 AS p;
-- END:insert23

-- START:insert4
INSERT INTO post_size_test_4 (post_id, attributes)
  SELECT post_id,
    JSON_OBJECT(
      REPEAT('post_title', 10): post_title,
      REPEAT('post_text', 10): post_title,
      REPEAT('user_id', 10): user_id,
      REPEAT('created_at', 10): created_at,
      REPEAT('updated_at', 10): updated_at
    )
  FROM post_size_test_1;
-- END:insert4

-- START:table-size-query
SELECT table_schema, table_name,
  pg_size_pretty(table_bytes) AS table,
  pg_size_pretty(index_bytes) AS index,
  pg_size_pretty(total_bytes) AS total
FROM (
  SELECT *, total_bytes - index_bytes
    - COALESCE(toast_bytes, 0) AS table_bytes
  FROM (
    SELECT
      c.oid,
      nspname AS table_schema,
      relname AS table_name,
      pg_total_relation_size(c.oid) AS total_bytes,
      pg_indexes_size(c.oid) AS index_bytes,
      pg_total_relation_size(reltoastrelid) AS toast_bytes
    FROM pg_class c
    LEFT JOIN pg_namespace n ON n.oid = c.relnamespace
    WHERE relkind = 'r'
  ) a
) a
WHERE table_schema = 'public' AND table_name LIKE 'post_size_test%'
ORDER BY table_name;
-- START:table-size-query
