USE test;
DROP TABLE IF EXISTS post;

-- START:create
CREATE TABLE post (
  post_id SERIAL,
  post_title TEXT NOT NULL,
  post_text TEXT NOT NULL,
  user_id BIGINT NOT NULL,
  revisions JSON CHECK(JSON_SCHEMA_VALID('{
      "$schema": "http://json-schema.org/draft-04/schema#",
      "title": "List of changes to a post",
      "type":"array",
      "items": {
        "type": "object",
	"properties": {
	  "revision": {
	    "type": "number"
	  },
	  "edit_date": {
	    "type": "string"
	  },
	  "editor": {
	    "type": "string"
	  }
	},
	"required": ["revision", "edit_date", "editor"],
	"additionalProperties": false
      }
    }', revisions))
);
-- END:create

-- Test document that should be OK given the JSON schema
INSERT INTO post SET
  post_title='title',
  post_text='text',
  user_id=1,
  revisions='[{"revision":1,"edit_date":"2025-06-30","editor":"Mike"}]';

-- Test document that should violate the JSON schema
INSERT INTO post SET
  post_title='title',
  post_text='text',
  user_id=1,
  revisions='[{"revision":2,"edit_date":"2025-06-30","editor":"Mike","foo":"bar"}]';

SELECT * FROM post;
