CREATE TABLE IF NOT EXISTS revision (
  post_id BIGINT REFERENCES post,
  revision INT,
  edit_date TIMESTAMP,
  editor TEXT,
  PRIMARY KEY (post_id, revision)
);

DELETE FROM revision;

INSERT INTO revision VALUES
  (1234, 2, '2025-05-10', 'Jules'),
  (1234, 3, '2025-05-12', 'Mike'),
  (1234, 4, '2025-05-15', 'Sharon');

-- START:query
SELECT post.* FROM post
JOIN revision AS r USING (post_id)
WHERE r.editor = 'Mike' AND r.edit_date = '2025-05-12';
-- END:query
