from cassandra.cluster import Cluster
from cassandra.query import dict_factory
from operator import itemgetter

cluster = Cluster()
session = cluster.connect()
session.set_keyspace("visage")

results = session.execute("SELECT post_id, view_count FROM post")

post_unsorted = []

for post in results:
    post_id = post.post_id

    comment_count = session.execute("""
        SELECT COUNT(*) AS count FROM comment
        WHERE post_id=%s
        ALLOW FILTERING""",
        [post_id])

    rating_count = session.execute("""
        SELECT COUNT(*) AS count FROM rating
        WHERE post_id=%s
        ALLOW FILTERING""",
        [post_id])

    engagement = post.view_count + comment_count[0][0] + rating_count[0][0]

    post_unsorted.append({"post_id": post_id, "engagement": engagement})

post_sorted = sorted(post_unsorted, key=itemgetter("engagement"), reverse=True)

print(post_sorted[:10])
