from pymongo import MongoClient

client = MongoClient("localhost")

visage = client["visage"]

results = visage.post.aggregate([
    {
        "$lookup": {
            "from": "comment",
            "localField": "id",
            "foreignField": "post_id",
            "pipeline": [
                { "$group": { "_id": None, "count": { "$count": {} } } }
            ],
            "as": "comment"
        }
    },
    {
        "$lookup": {
            "from": "rating",
            "localField": "id",
            "foreignField": "post_id",
            "pipeline": [
                { "$group": { "_id": None, "count": { "$count": {} } } }
            ],
            "as": "rating"
        }
    },
    {
        "$project": {
            "id": 1,
            "title": 1,
            "user_id": 1,
            "engagement": {
                "$add": [
                    { "$ifNull": [ "$view_count", 0 ] },
                    { "$ifNull": [ "$comment[0].count", 0 ] },
                    { "$ifNull": [ "$rating[0].count", 0 ] }
                ]
            }
        }
    },
    { "$sort": { "engagement": -1 } },
    { "$limit": 10 }
])

for f in results:
    print(f)

client.close()
