from cassandra.cluster import Cluster

cluster = Cluster()
session = cluster.connect()

session.execute("DROP KEYSPACE IF EXISTS visage")
session.execute("""
    CREATE KEYSPACE visage
    WITH REPLICATION = { 'class': 'SimpleStrategy', 'replication_factor': 1}""")
session.set_keyspace("visage")

session.execute("""
    CREATE TABLE post (
        post_id INT PRIMARY KEY,
        title TEXT,
        user_id INT,
        view_count INT
    )
    """)

stmt = session.prepare("""
    INSERT INTO post (post_id, title, user_id, view_count) VALUES (?, ?, ?, ?)""")

post_data = [
    [1234, "Who's On First?", 3, 2902909],
    [5678, "Horse Feathers Password Scene", 4, 1526278],
    [9012, "Duck Soup Mirror Scene", 5, 1384194]
]

for row in post_data:
    session.execute(stmt, row)

session.execute("""
    CREATE TABLE comment (
        comment_id INT PRIMARY KEY,
        post_id INT,
        comment_text TEXT,
        in_reply_to INT,
        user_id INT
    )
    """)

stmt = session.prepare("""
    INSERT INTO comment (comment_id, post_id, comment_text, in_reply_to, user_id) VALUES (?, ?, ?, ?, ?)""")

comment_data = [
    [1, 1234, "Well, let's see, we have on the St Louis team, Who's on first, What's on second, I Don't Know is on third...", None, 1],
    [2, 1234, "That's what I want to find out.", 1, 2],
    [3, 1234, "I say Who's on first, What's on second, I Don't Know's on third.", 2, 1],
    [4, 1234, "Are you the manager?", 3, 2],
    [5, 1234, "Yes.", 4, 1],
    [6, 1234, "You gonna be the coach too?", 5, 2],
    [7, 1234, "Yes.", 6, 1],
    [8, 1234, "And you don't know the fellows' names?", 7, 2],
    [9, 1234, "Well I should.", 8, 1],
    [10, 1234, "Well then who's on first?", 9, 2],
    [11, 1234, "Yes.", 10, 1]
]

for row in comment_data:
    session.execute(stmt, row)

session.execute("""
    CREATE TABLE rating (
        post_id INT,
        user_id INT,
        rating TINYINT,
        PRIMARY KEY (post_id, user_id)
    )
    """)

stmt = session.prepare("""
    INSERT INTO rating (post_id, user_id, rating) VALUES (?, ?, ?)""")

rating_data = [
    [1234, 3, 2],
    [1234, 4, 4]
]

for row in rating_data:
    session.execute(stmt, row)
