from typing import TypedDict
from pymongo import MongoClient
from datetime import datetime

class Post(TypedDict):
    title: str
    text: str
    user_id: int
    view_count: int

post_data = [
    Post(id=1234, title="Who's On First?", user_id=3, view_count=2902909),
    Post(id=5678, title="Horse Feathers Password Scene", user_id=4, view_count=1526278),
    Post(id=9012, title="Duck Soup Mirror Scene", user_id=5, view_count=1384194)
]

class Comment(TypedDict):
    post_id: int
    comment: str
    in_reply_to: int
    user_id: int
    created_at: datetime

comment_data = [
    Comment(id=1, post_id=1234, comment="Well, let's see, we have on the St Louis team, Who's on first, What's on second, I Don't Know is on third...", user_id=1),
    Comment(id=2, post_id=1234, comment="That's what I want to find out.", in_reply_to=1, user_id=2),
    Comment(id=3, post_id=1234, comment="I say Who's on first, What's on second, I Don't Know's on third.", in_reply_to=2, user_id=1),
    Comment(id=4, post_id=1234, comment="Are you the manager?", in_reply_to=3, user_id=2),
    Comment(id=5, post_id=1234, comment="Yes.", in_reply_to=4, user_id=1),
    Comment(id=6, post_id=1234, comment="You gonna be the coach too?", in_reply_to=5, user_id=2),
    Comment(id=7, post_id=1234, comment="Yes.", in_reply_to=6, user_id=1),
    Comment(id=8, post_id=1234, comment="And you don't know the fellows' names?", in_reply_to=7, user_id=2),
    Comment(id=9, post_id=1234, comment="Well I should.", in_reply_to=8, user_id=1),
    Comment(id=10, post_id=1234, comment="Well then who's on first?", in_reply_to=9, user_id=2),
    Comment(id=11, post_id=1234, comment="Yes.", in_reply_to=10, user_id=1)
]

class Rating(TypedDict):
    post_id: int
    user_id: int
    rating: int

rating_data = [
    Rating(post_id=1234, user_id=3, rating=2),
    Rating(post_id=1234, user_id=4, rating=4)
]

client = MongoClient("localhost")

visage = client["visage"]

visage.post.drop()
visage.comment.drop()
visage.rating.drop()

with client.start_session() as session:
    session.start_transaction()
    try:
        visage.post.insert_many(post_data)
        visage.comment.insert_many(comment_data)
        visage.rating.insert_many(rating_data)
        session.commit_transaction()
    except Exception as e:
        print("an error occurred: ", e)
        sess.abort_transaction()

client.close()
