SELECT p.post_id, (p.view_count
    + COALESCE(c.comment_count,0)
    + COALESCE(r.rating_count,0)) AS engagement
FROM post AS p
LEFT OUTER JOIN (
  SELECT post_id, COUNT(*) as comment_count
  FROM comment
  GROUP BY post_id
) AS c USING (post_id)
LEFT OUTER JOIN (
  SELECT post_id, COUNT(*) AS rating_count
  FROM rating
  GROUP BY post_id
) AS r USING (post_id)
ORDER BY engagement DESC
LIMIT 10;
