from cassandra.cluster import Cluster
from cassandra.query import dict_factory
from operator import itemgetter

cluster = Cluster()
session = cluster.connect()
session.set_keyspace("visage")

results = session.execute("""
    SELECT post_id, COUNT(*) AS engagement
    FROM post_event
    WHERE event_type IN ('COMMENT', 'VIEW', 'RATING')
    GROUP BY post_id
    ALLOW FILTERING""")

for post in results:
    print(post)
