from pymongo import MongoClient

client = MongoClient("localhost")

visage = client["visage"]

results = visage.post.aggregate([
    {
        "$project": {
            "id": 1,
            "title": 1,
            "user_id": 1,
            "engagement": {
                "$add": [
                    { "$ifNull": [ "$view_count", 0 ] },
                    { "$size": { "$ifNull": [ "$comments", [] ] } },
                    { "$size": { "$ifNull": [ "$ratings", [] ] } }
                ]
            }
        }
    },
    { "$sort": { "engagement": -1 } },
    { "$limit": 10 }
])

for f in results:
    print(f)

client.close()
