from cassandra.cluster import Cluster
from cassandra.util import datetime_from_timestamp

cluster = Cluster()
session = cluster.connect()

session.execute("DROP KEYSPACE IF EXISTS visage")
session.execute("""
    CREATE KEYSPACE visage
    WITH REPLICATION = { 'class': 'SimpleStrategy', 'replication_factor': 1}""")
session.set_keyspace("visage")

session.execute("""
    CREATE TABLE post_event (
        post_id INT,
        id UUID,
        event_type TEXT,
        event_dt TIMESTAMP,
        user_id INT,
        content TEXT,
        rating INT,
        PRIMARY KEY (post_id, id)
    )
    """)

dt = datetime_from_timestamp(0)

stmt = session.prepare("""
    INSERT INTO post_event (post_id, id, event_type, event_dt, user_id, content, rating)
    VALUES (?, NOW(), ?, ?, ?, ?, ?)""")

post_event_data = [
        [1234, "POST", dt, 1, "Who's On First?", None],
        [1234, "COMMENT", dt, 1, "Who's On First?", None],
        [1234, "COMMENT", dt, 1, "Well, let's see, we have on the St Louis team, Who's on first, What's on second, I Don't Know is on third...", None],
        [1234, "COMMENT", dt, 2, "That's what I want to find out.", None],
        [1234, "COMMENT", dt, 1, "I say Who's on first, What's on second, I Don't Know's on third.", None],
        [1234, "COMMENT", dt, 2, "Are you the manager?", None],
        [1234, "COMMENT", dt, 1, "Yes.", None],
        [1234, "COMMENT", dt, 2, "You gonna be the coach too?", None],
        [1234, "COMMENT", dt, 1, "Yes.", None],
        [1234, "COMMENT", dt, 2, "And you don't know the fellows' names?", None],
        [1234, "COMMENT", dt, 1, "Well I should.", None],
        [1234, "COMMENT", dt, 2, "Well then who's on first?", None],
        [1234, "COMMENT", dt, 1, "Yes.", None],
        [1234, "VIEW", dt, 42, None, None],
        [1234, "VIEW", dt, 43, None, None],
        [1234, "VIEW", dt, 44, None, None],
        [1234, "RATING", dt, 3, None, 2],
        [1234, "RATING", dt, 4, None, 4],
        [5678, "POST", dt, 4, "Horse Feathers Password Scene", None],
        [5678, "VIEW", dt, 42, None, None],
        [9012, "POST", dt, 5, "Duck Soup Mirror Scene", None],
        [9012, "VIEW", dt, 43, None, None]
    ]

for row in post_event_data:
    session.execute(stmt, row)
