from flask import Flask, request, render_template
from flask_caching import Cache
import psycopg2
import psycopg2.extras

app = Flask(__name__)
cache = Cache(app, config={'CACHE_TYPE': 'SimpleCache'})

@app.route("/comments", methods=['GET'])
def comments():
    page = request.args.get('page', default=1, type=int)

    comments_paged = cache.get('comments')

    if comments_paged is None or page == 1:
        comments_paged = get_comments()
        cache.set('comments', comments_paged)

    return render_template('comments.html',
                           comments=comments_paged[page],
                           next_page=page+1)

# fetch 10 pages of comments from database
# and separate into pages of 5 comments each
def get_comments():
    num_pages = 10
    page_size = 5

    comments_paged = [[]] * (num_pages+1)

    with psycopg2.connect("dbname='visage' host='localhost'") as conn:

        cur = conn.cursor(cursor_factory=psycopg2.extras.RealDictCursor)

        sql = f"""
            SELECT * FROM comment
            ORDER BY comment_id
            FETCH FIRST {num_pages * page_size} ROWS ONLY
        """
        cur.execute(sql)
        rows = cur.fetchall()

        for page in range(num_pages):
            start = page * page_size
            end = start + page_size
            comments_paged[page+1] = rows[start:end]

    return comments_paged

if __name__ == '__main__':
    app.run()
