SELECT 'Count' AS CommentsPerMonth,
  [2022-01], [2022-02], [2022-03], [2024-12], [2025-01], [2025-02]
FROM (
  SELECT FORMAT([created_at], 'yyyy-MM') AS ym, comment_id
  FROM comment
) AS SourceTable
PIVOT (
  COUNT(comment_id) FOR ym IN
  ([2022-01], [2022-02], [2022-03], [2024-12], [2025-01], [2025-02])
) AS PivotTable;
