import psycopg2
import psycopg2.extras

conn = psycopg2.connect("dbname='visage' host='localhost'")

with conn.cursor(cursor_factory=psycopg2.extras.RealDictCursor) as cur:
    sql = """
        SELECT DISTINCT TO_CHAR(created_at, 'YYYY-MM') AS ym FROM comment
    """
    cur.execute(sql)
    ym_list = cur.fetchall()

    pivot_exprs = [f"""
        COUNT(CASE TO_CHAR(created_at, 'YYYY-MM')
            WHEN '{ym['ym']}' THEN 1 END) AS "{ym['ym']}"
    """ for ym in ym_list]

    sql = f"""
        SELECT {','.join(pivot_exprs)} FROM comment
    """
    cur.execute(sql)
    print(cur.fetchall())
