import psycopg2
import psycopg2.extras

conn = psycopg2.connect("dbname='visage' host='localhost'")

with conn.cursor(cursor_factory=psycopg2.extras.RealDictCursor) as cur:
    sql = """
        SELECT DISTINCT TO_CHAR(created_at, 'YYYY-MM') AS ym FROM comment
    """
    cur.execute(sql)
    ym_list = cur.fetchall()

    crosstab_columns = [f"""
        "{ym['ym']}" BIGINT
    """ for ym in ym_list]

    sql = f"""
        SELECT * FROM CROSSTAB(
          'SELECT NULL, TO_CHAR(created_at, ''YYYY-MM''), COUNT(*)
          FROM comment
          GROUP BY TO_CHAR(created_at, ''YYYY-MM'') ORDER BY 2'
        ) AS ct(row_name TEXT,
          {','.join(crosstab_columns)})
    """
    cur.execute(sql)
    print(cur.fetchall())
