import psycopg2
import psycopg2.extras

conn = psycopg2.connect("dbname='visage' host='localhost'")

with conn.cursor(cursor_factory=psycopg2.extras.RealDictCursor) as cur:
    sql = """
        SELECT DISTINCT TO_CHAR(created_at, 'YYYY-MM') AS ym,
          DATE_TRUNC('month', created_at)::date AS start,
          DATE_TRUNC('month', created_at)::date
          + MAKE_INTERVAL(MONTHS=>1) AS end
        FROM comment
    """
    cur.execute(sql)
    ym_list = cur.fetchall()

    pivot_exprs = [f"""
        (SELECT COUNT(*) FROM comment
         WHERE created_at BETWEEN
            '{ym['start']}' AND '{ym['end']}') AS "{ym['ym']}"
    """ for ym in ym_list]

    sql = f"""
        SELECT {','.join(pivot_exprs)}
    """
    cur.execute(sql)
    print(cur.fetchall())
