import psycopg2
import psycopg2.extras

conn = psycopg2.connect("dbname='visage' host='localhost'")

with conn.cursor(cursor_factory=psycopg2.extras.RealDictCursor) as cur:
    sql = """
        SELECT TO_CHAR(created_at, 'YYYY-MM') AS ym, COUNT(*) AS count
        FROM comment
        GROUP BY TO_CHAR(created_at, 'YYYY-MM')
    """
    cur.execute(sql)

    pivoted_row = {}
    for row in cur:
        pivoted_row[row['ym']] = row['count']

    print(pivoted_row)
