import os
import psycopg2
import psycopg2.extras
import time

def process_notifications(post_id):
    print(f"Notifying for post {post_id}")

conn = psycopg2.connect("dbname='visage' host='localhost'")

while True:

    with conn:

        with conn.cursor() as cur:

            cur.execute("""
                SELECT post_id FROM post
                WHERE updated_at > NOW() - INTERVAL '1' MINUTE
                  AND notified_at IS NULL
            """)

            posts = cur.fetchall()

            for post in posts:
                post_id = post[0]

                process_notifications(post_id)

                cur.execute("""
                    UPDATE post SET notified_at = NOW()
                    WHERE post_id = %(post_id)s
                """, {'post_id': post_id})

    print("Checked for posts...")
    time.sleep(60)
    time.sleep(1)
    time.sleep(10)
    if "VISAGE_CHECK_DELAY" in os.environ:
        time.sleep(int(os.environ["VISAGE_CHECK_DELAY"]))
