from datetime import datetime, timezone
from flask import Flask, render_template
from flask_sqlalchemy import SQLAlchemy
from sqlalchemy import JSON
from sqlalchemy.orm import DeclarativeBase, Mapped, mapped_column

flask_app = Flask(__name__)
flask_app.config.from_mapping(
    SECRET_KEY="visage_key",
    SQLALCHEMY_DATABASE_URI="postgresql+psycopg2://localhost:5432/visage",
    SQLALCHEMY_ECHO=True,
    SQLALCHEMY_BINDS={
        "shard1": "postgresql+psycopg2://visage:xyzzy@localhost:5433/visage",
        "shard2": "postgresql+psycopg2://visage:xyzzy@localhost:5434/visage",
        "shard3": "postgresql+psycopg2://visage:xyzzy@localhost:5435/visage",
    },
)

class Base(DeclarativeBase):
  pass

db = SQLAlchemy(model_class=Base)
db.init_app(flask_app)

class Log(db.Model):
    __tablename__ = "log"

    log_id: Mapped[int] = mapped_column(primary_key=True)
    log_type: Mapped[int] = mapped_column(nullable=False)
    log_data: Mapped[JSON] = mapped_column(type_=JSON, nullable=False)
    created_at: Mapped[datetime] = mapped_column(
        default=lambda: datetime.now(timezone.utc))

    @staticmethod
    def query(query, shards=["shard1", "shard2", "shard3"]):
        results = []
        for shard in shards:
            with db.engines[shard].begin() as shard_db:
                shard_results = shard_db.execute(query).fetchall()
                results.extend(shard_results)
        return results

@flask_app.route("/logs")
def logs():
    logs = Log.query(
        db.select(Log.log_id, Log.created_at, Log.log_type, Log.log_data)
    )
    return render_template("logs.html",
                           logs=logs)

@flask_app.route("/")
def home():
    return render_template("home.html")

if __name__ == "__main__":
    flask_app.run(port=8080, debug=True)
