#---
# Excerpted from "Eloquent Ruby",
# published by The Pragmatic Bookshelf.
# Copyrights apply to this code. It may not be used to create training material,
# courses, books, articles, and the like. Contact us if you are in doubt.
# We make no guarantees that this code is fit for any purpose.
# Visit https://pragprog.com/titles/eruby2 for more book information.
#---
require "rspec"

describe "Regexp.===" do
  it "matches a string but is not equal" do
    expect(
    /Roswell.*/.match?("Roswell")       # Yes!
    ).to be_truthy

    expect(
    /Roswell.*/ == "Roswell"            # No!
    ).to be_falsey
  end

  it "works in a case statement" do
    expect do
      location = "area 51"

      case location
      when /area.*/
        puts "We are in an area!"
      when /Roswell.*/
        puts "We are in Roswell!"
      else
        # ... 
      end
    end.to output(/an area/).to_stdout
  end
end
