import time
import find_remove_find5
import sort_then_find3
import walk_through7

from typing import Callable, Any

def time_find_two_smallest(find_func: Callable[list[list[float]], Any],
                           lst: list[float]) -> float:
    """Return how many seconds find_func(lst) took to execute.
    """

    t1 = time.perf_counter()
    find_func(lst)
    t2 = time.perf_counter()
    return (t2 - t1) * 1000.0

if __name__ == '__main__':
    # Gather the sea level pressures
    sea_levels = []
    with open('sea_levels.txt', 'r') as sea_levels_file:
        for line in sea_levels_file:
            sea_levels.append(float(line))

    # Time each of the approaches
    find_remove_find_time = time_find_two_smallest(
        find_remove_find5.find_two_smallest, sea_levels)

    sort_get_minimums_time = time_find_two_smallest(
        sort_then_find3.find_two_smallest, sea_levels)

    walk_through_time = time_find_two_smallest(
        walk_through7.find_two_smallest, sea_levels)

    print(f'"Find, remove, find" took {find_remove_find_time:.2f}ms.')
    print(f'"Sort, get minimums" took {sort_get_minimums_time:.2f}ms.')
    print(f'"Walk through the list" took {walk_through_time:.2f}ms.')
