>>> def load_data(filename: str) -> str:
...     """Return the contents of the file `filename`."""
...     try:
...         with open(filename) as infile:
...             return infile.read()
...     except FileNotFoundError as eo:
...         raise DataLoadError(f'Could not load data from {filename}') from eo
...         
>>> try:
...     load_data('missing.txt')
... except DataLoadError as eo:
...     print(eo)
...     print('Original cause: {eo.__cause__}')
...     
Could not load data from missing.txt
Original cause: [Errno 2] No such file or directory: 'missing.txt'
