>>> def load_data(filename: str) -> str:
...     """Return the contents of the file `filename`."""
...     try:
...         with open(filename) as infile:
...             return infile.read()
...     except FileNotFoundError as eo:
...         raise IOError(f'Could not load data from {filename}') from eo
...         
>>> import traceback
... try:
...     load_data('missing.txt')
... except IOError as eo:
...     print(eo)
...     print(f'Original cause: {eo.__cause__}')
...     traceback.print_exception(eo)
...
Could not load data from missing.txt
Original cause: [Errno 2] No such file or directory: 'missing.txt'
Traceback (most recent call last):
  File "<python-input-2>", line 3, in load_data
    with open(filename) as infile:
         ~~~~^^^^^^^^^^
FileNotFoundError: [Errno 2] No such file or directory: 'missing.txt'

The above exception was the direct cause of the following exception:

Traceback (most recent call last):
  File "<python-input-5>", line 3, in <module>
    load_data('missing.txt')
    ~~~~~~~~~^^^^^^^^^^^^^^^
  File "<python-input-2>", line 6, in load_data
    raise IOError(f'Could not load data from {filename}') from eo
OSError: Could not load data from missing.txt
