>>> from typing import Sequence
>>> def divide(a: float, b: float) -> float:
...     """Return the ratio of the numbers `a` and `b`. """
...     return a / b
...     
>>> def average(seq: Sequence[float]) -> float:
...     """Return the average of the items in the sequence. """
...     return divide(sum(seq), len(seq))
...     
>>> avg = average([])
Traceback (most recent call last):
  File "<python-input-2>", line 1, in <module>
    average([])
    ~~~~~~~^^^^
  File "<python-input-1>", line 2, in average
    return divide(sum(seq), len(seq))
  File "<python-input-0>", line 2, in divide
    return a / b
           ~~^~~
ZeroDivisionError: division by zero
>>> try:
...     avg = average([])
... except Exception as eo:
...     for arg in eo.args:
...         print(arg)
...     print(type(eo))
...     
division by zero
<class 'ZeroDivisionError'>
