with open('hopedale.txt', 'r') as hopedale_file:

    # Read and skip the description line.
    hopedale_file.readline()

    # Keep reading and skipping comment lines until we read the first piece
    # of data.
    data = hopedale_file.readline()
    while data.startswith('#'):
        data = hopedale_file.readline()

    # Now we have the first piece of data.  Accumulate the total number of
    # pelts.
    total_pelts = int(data)

    # Read the rest of the data.
    for data in hopedale_file:
        total_pelts += int(data) 

print(f'Total number of pelts: {total_pelts}')
