def pie_percent(n: int) -> int:
    """Return the percentage of a pie that each person gets to eat if n
    people are sharing the pie.

    >>> pie_percent(5)
    20
    >>> pie_percent(2)
    50
    >>> pie_percent(1)
    100

    """

    return int(100 / n)


def pie_percent(n: int) -> int:
    """Assuming there are n people who want to eat a pie, return the
    percentage of the pie that each person gets to eat.

    Precondition: n > 0

    >>> pie_percent(5)
    20
    >>> pie_percent(2)
    50
    >>> pie_percent(1)
    100

    """

    return int(100 / n)

if __name__ == '__main__':
    import doctest
    doctest.testmod()
