>>> from collections.abc import Iterator
>>> def make_down_counter(initial: int) -> Iterator[int]:
...     """ Yield a countdown from `initial` down to 1 (inclusive).
...
...     The argument is converted to an integer using `int(initial)`. 
...     If the resulting value is <= 0, the generator yields nothing.
...
...     >>> list(make_down_counter(3))
...      [3, 2, 1]
...     """
...
...     value = initial
...     while value > 0:
...         yield value
...         value -= 1
...     return
...     
>>> down_counter = make_down_counter(3)
>>> next(down_counter)
3
>>> next(down_counter)
2
>>> next(down_counter)
1
>>> next(down_counter)
Traceback (most recent call last):
  File "<python-input-6>", line 1, in <module>
    next(down_counter)
    ~~~~^^^^^^^^^
StopIteration
>>> down_counter = make_down_counter(3)
>>> for val in down_counter:
...     print(val)
...     
3
2
1
