data = ['#Mary', 'had', 'a', 'little', '#lamb']

result = [
    item[1:]                # map
    for item in data
    if item.startswith('#') # filter
]                           # reduce (implicit list construction)
print(result) # ['Mary', 'lamb']

result1 = [item for item in data if item.startswith('#')]
print(result1) # ['#Mary', '#lamb']
result2 = [1 for item in data if item.startswith('#')]
print(result2) # [1, 1]
print(len(result2)) # 2

result = [item for item in data]
print(result == data[:]) # True
