text = '''This book is about Python programming. Python is a popular and
efficient programming language. A Python programmer is thoughtful and
pragmatic. Be like a Python programmer.'''
sentences = text.lower().replace('?', '.').replace('!', '.').split('.')
print(sentences)
# ['this book is about python programming',
# ' python is a popular and\nefficient programming language',
# ' a python programmer is thoughtful and\npragmatic',
# ' be like a python programmer']
stops = {'and', 'the', 'in', 'this', "don't", 'was', 'that', 'to', 'a', 
         'its', 'as', 'had', 'about', 'is', 'be'}
tokens = [filter(lambda word: word not in stops, s.split())
          for s in sentences]
print(tokens)
# [<filter object at 0x7f34eb4862c0>, <filter object at 0x7f34eb485a50>,
#  <filter object at 0x7f34eb4860b0>, <filter object at 0x7f34eb486170>,
#  <filter object at 0x7f34eb4861a0>]

from itertools import combinations, chain, takewhile

pairs = map(lambda words: combinations(words, 2), tokens)
all_pairs = chain.from_iterable(pairs)
print(all_pairs)
# <itertools.chain object at 0x7f9fb6b119f0>

from collections import Counter

counts = Counter(all_pairs)
print(counts)
# Counter({('python', 'programming'): 2, ('python', 'programmer'): 2,
# ('book', 'python'): 1, ('book', 'programming'): 1, ('python', 'popular'): 1,
# ('python', 'efficient'): 1, ('python', 'language'): 1,
# ('popular', 'efficient'): 1, ('popular', 'programming'): 1,
# ('popular', 'language'): 1, ('efficient', 'programming'): 1,
# ('efficient', 'language'): 1, ('programming', 'language'): 1,
# ('python', 'thoughtful'): 1, ('python', 'pragmatic'): 1,
# ('programmer', 'thoughtful'): 1, ('programmer', 'pragmatic'): 1,
# ('thoughtful', 'pragmatic'): 1, ('like', 'python'): 1,
# ('like', 'programmer'): 1})
items = counts.most_common()
print(items)
# [(('python', 'programming'), 2), (('python', 'programmer'), 2),
#  (('book', 'python'), 1), (('book', 'programming'), 1),
#  (('python', 'popular'), 1), (('python', 'efficient'), 1),
#  (('python', 'language'), 1), (('popular', 'efficient'), 1),
#  (('popular', 'programming'), 1), (('popular', 'language'), 1),
#  (('efficient', 'programming'), 1), (('efficient', 'language'), 1),
#  (('programming', 'language'), 1), (('python', 'thoughtful'), 1),
#  (('python', 'pragmatic'), 1), (('programmer', 'thoughtful'), 1),
#  (('programmer', 'pragmatic'), 1), (('thoughtful', 'pragmatic'), 1),
#  (('like', 'python'), 1), (('like', 'programmer'), 1)]
popular = takewhile(lambda item: item[1] > 1, items)
print(popular)
# <itertools.takewhile object at 0x7f3f941a4800>

from operator import itemgetter

print(list(map(itemgetter(0), popular)))
# [('python', 'programming'), ('python', 'programmer')]

print(list(map(itemgetter(0),
               takewhile(lambda item: item[1] > 1,
                         Counter(chain.from_iterable(
                             map(lambda words: combinations(words, 2),
                                 (filter(lambda word: word not in stops,
                                         s.split()) for s in
                                  text.lower().split('.')))))
                    .most_common()))))
# [('python', 'programming'), ('python', 'programmer')]
