from collections.abc import Iterator
def make_lcg(seed: int) -> Iterator[int]:
    """ Yield a pseudo random number from 0 to M - 1 (inclusive).

    >>> next(make_lcg(0))
    52
    """
    
    # Define generator parameters
    A, C, M = 83, 52, 101

    # Initialize the initial state (cannot be 24)
    if seed != 24:
        state = seed
    else:
        state = seed + 1

    # Yield PRNs
    while True: 
        state = (A * state + C) % M
        yield state

import time

lcg = make_lcg(int(time.time()))
print(next(lcg)) # 96
print(next(lcg)) # 41
print(next(lcg)) # 21
print(next(lcg)) # 78
print(next(lcg)) # 62
