>>> from math import sqrt, pow
>>> def distance(x1: float, y1: float, x2: float, y2: float) -> float:
...     """Return the euclidean distance between the points `(x1,y1)`
...     and `(x2,y2)`.
...     """
...     return sqrt(pow(x1 - x2, 2) + pow(y1 - y2, 2))
...     
>>> origin = (0, 0) # x1, y1
>>> other = (3, 4)  # x2, y2
>>> distance(origin[0], origin[1], other[0], other[1]) # Good
5.0
>>> distance(origin[0], origin[1], *other) # Better
5.0
>>> distance(*origin, *other) # Best
5.0
