def print_table(n: int) -> None:
    """Print the multiplication table for numbers 1 through n inclusive.

    >>> print_table(5)
        1       2       3       4       5
    1   1       2       3       4       5
    2   2       4       6       8       10
    3   3       6       9       12      15
    4   4       8       12      16      20
    5   5       10      15      20      25
    """
    # The numbers to include in the table.
    numbers = range(1, n + 1)

    # Print the header row.
    for i in numbers:
        print(f'\t{i}', end='')

    # End the header row.
    print()

    # Print each row number and the contents of each row.
    for i in numbers:  #(1)
        print (i, end='')  #(2)
        for j in numbers:   #(3)
            print(f'\t{i * j}', end='') #(4)

        # End the current row.
        print() #(5)
