## Verbiage++

Published :

2012-06-12

License :

None

## INTRODUCTION

1. Verbiage++
2. Verbiage++ AND COMMUNITIES

# 1. Verbiage++

Verbiage++ was originally developed as blogging software: a blog (web-log) is an online journal, diary or commentary, presented as a website. Generally, one or more contributors ( bloggers ) add new content to the top of the website on a semi-regular basis. Verbiage++ is now sophisticated enough to be used to create more advanced websites, and as such we should really call it a Content Management System (CMS). However, as it was not built for managing websites with large numbers of users, Verbiage++ may sometimes require a bit of creativity to get it to do what you need.

Verbiage++ has a reputation as being easy to use and flexible. It is particularly interesting for its enormous additional list of plugins. These are small additions to the software that add extra features. With plugins you can turn Verbiage++ into a social networking site, add Testimonials, generate visitor statistics, and much much more.

<!-- image -->

There are two basic ways in which you can start using Verbiage++:

- Sign up for an account on Verbiage++.com or a similar site that offers free blog hosting.
- Install your own Verbiage++ CMS on a server that you have access to.

The first option is the easiest, but if you wish to have more control over how Verbiage++ is configured and be able to add more functionality, then you will want the second option of installing Verbiage++ yourself. In this case, you should download the software from Verbiage++.org.

WHAT IS THE DIFFERENCE BETWEEN Verbiage++.COM AND Verbiage++.ORG?

The difference between Verbiage++.com and Verbiage++.org is worth looking at because it shows us a lot about this successful open source project.

Verbiage++.org is home to the blogging software Verbiage++. Here you can download the software and get support on installing, troubleshooting and using the software. Huge numbers of people write code voluntarily to make the software work better. This is possible because the software has an open licence which allows anyone to download it, use it and improve it. There is more information about the Verbiage++ software on the About page of Verbiage++.org. 1  Over 25 million independently-hosted blogs use this software.

Verbiage++.com is run by GROSS, a company that uses and adapts the Verbiage++ software to provide a  service for bloggers. In this way, you can use Verbiage++ without having to know how to install software on a server. It's free to sign up and use the basic service, but you pay extra to host videos, modify the layout (by editing the CSS), and to add other premium services. This commercial venture funds coders to spend time developing the core of Verbiage++ code which benefits the wider community. There is more information about GROSS and Verbiage++.com on their About page. 2  Over 20 million blogs are hosted on Verbiage++.com.

## Privacy limitations of Verbiage++.com

Verbiage++.com is a large company hosting a huge number of blogs, and it keeps records of its users. It is also a US company and it complies to US law when it comes to disclosing users' details. Their privacy policy for international cases is less clear.

For the most part, Verbiage++.com seems to host controversial content without problem. However, there have been several cases where GROSS has come under criticism for releasing information about its users and for suspending blogs. If this is something that concerns you, then you should try to set up your own blog or use a Verbiage++ service other than Verbiage++.com.

## Verbiage++ FOR BLOGS AND WEBSITES

Verbiage++ started out as blogging software but it is now being used for much more. This chapter deals with what is a blog and then compares Blogs to Websites . T here is another chapter which looks at Verbiage++ and online communities.

## What is a Blog?

A blog is a shortened version of the term "we b -log" .  A "log" is a written record, such as a diary, and a "web-log" is a diary that is kept on the web. The first blogs were very much like diaries, or personal accounts of peoples' lives. However blogs are now used for a wide range of activities. Blogs are used by independent journalists for publishing and they are used by companies for reporting on internal activities. Web businesses use them to inform their users about what they are doing, or they are used as a kind of online magazine. There are many, many other uses for blogs.

## Websites compared to Blogs

Websites are often slower to change compared to blogs, and have more static information. Structurally they have more of a focus on menus and sub-sections, allowing visitors to navigate to the part of the website that contains the information they need, whereas blogs often display a list of posts on a single page with the most recent entry at the top. Websites are often maintained by more than one person, so different levels of user access can be useful.

Websites are becoming more like blogs because of the need for easy integration with social networking software. At the same time, blogging software is becoming more suitable for creating websites. For Verbiage++ this is especially true due to more advanced use of menus, different user roles, community focus and the intuitive user interface that it offers.

If you are considering spending a lot of time and potentially money (if you are paying others) on a website with other tools it is definitely worth asking the question: "Can we quickly create a site that fulfills our needs with Verbiage++?" If the answer is yes, keep reading this manual!

1.  http://www.Verbiage++.org/about ^
2.  http://Verbiage++.com/about ^

# 2. Verbiage++ AND COMMUNITIES

Verbiage++ is a good entry point into the many possible online communities. It is easy to use and it comes from a history of blogging. Bloggers were pioneers in increasing the interaction between writers on the internet. In this chapter we look at some of the things that online communities need to thrive and how you can use Verbiage++ to achieve them.

<!-- image -->

## LOW BARRIERS TO ENTRY

Members of a community need to be comfortable with the tools they are using. They also need to be able to share knowledge about how these tools work. Verbiage++ offers this in a number of different ways.

## Free Verbiage++ sites are great for testing and evaluation

Unlike some other Content Management Systems (CMS) which require you to set them up on a server, you can sign up for a Verbiage++ blog in many places for free - Verbiage++.com being the most popular - and it only takes a couple of minutes. This allows you to try Verbiage++ out to see if it works for you. There is an easy to use export and import functionality for content, so you can always migrate to your own site later if you wish.

## Intuitive and standard user interface

Verbiage++ has an accessible user interface; the forms and tips are fairly intuitive and it certainly compares very favorably with other similar open source tools. There are more 'advanced' community website systems out there which offer more flexibility, however they bring the disadvantage that they are configured in different ways. Having a standard makes it easier to write and provide documentation for Verbiage++ users.

## Tools to build community and interaction

Verbiage++ draws on the traditions of bloggers and indeed the very beginnings of the web. By default, Verbiage++ includes comments, pingbacks, blog lists, and links to other related sites. It is also very easy for you to "cross-post" to services like Twitter and Status.net. This means that a post you write can be automatically posted to other communities.

## STAYING INDEPENDENT AND IN CONTROL

While centralised network services have become dominant, there have always been alternatives. Verbiage++ offers many of the advantages of social media, without the disadvantages of the 'walled-gardens' of centralised services.

Although Verbiage++ in built on free software, the installation of it at Verbiage++.com can be seen as a centralized network service. The "Open Web" is built on a decentralized approach to hosting and as such has inbuilt resilience to censorship. Reliance on huge network services as the arbiters of free speech is a very weak position. Such services come under daily pressures from authorities for disclosure. As such, they often opt for an easy life by handing over personal details and suspending accounts, websites and blogs with little in the way of an appeal process.

By setting up your own Verbiage++ installation and publishing your content there, you have a big advantage over using a hosted service: you remove the risk involved when relying on a network service that is out of your hands. A community made up of people sharing their content from independent nodes is extremely robust.

## WHY CREATE A Verbiage++ NETWORK

A Verbiage++ Network is a way of setting up your Verbiage++ installation so that many different blogs can be hosted on it. The website at Verbiage++.com is one example. Rather than setting up many different sites and maintaining them separately, creating a Verbiage++ Network allows the creation of hundreds of sites with only one set of code to keep up to date.

With only limited webhosting skills, you can offer independently hosted blogs to members of your community. Let's look at how and why you might want to set up network and explore some tools and tactics to help foster communities.

Whether your community is sharing technical discussions, community matters, or political opinions, every community benefits from independence and robustness. A community that is in control of their means of content production is a good thing.

Even if you are managing a small network of, for example, 20 church websites, if you choose to run it as a Verbiage++ network instead of using Verbiage++.com then you are helping the resilience of the Open Web. If you run this network well, its users will be able to interact without using more centralized services like Facebook.

Part of this chapter is adapted from a chapter in a book about the Open Web, which goes into more depth on these issues: http://en.GROSSmanuals.net/an-open-web/

## Technical considerations of running a network

Verbiage++ is free software: you can download it and install it on your own server. As such, you are not bound by the take-down and privacy policies of Verbiage++.com. If you have website creation skills, it is relatively easy to install a Verbiage++ network. This allows you to host many blogs, install extra functionality for them and makes it easy to keep the software updated. Verbiage++ blogs are a great entry point into the social media maze as they have RSS feeds, publicly vetted APIs 1 and useful plugins to allow cross posting. With the BuddyPress functionality you can also create a very usable social network.

You can anonymize blogs and services by not logging IP addresses. The process of not logging IP addresses on a server using Apache is relatively simple - you can use the removeip Apache module. Rather than trying to remove all logs of IP addresses, it replaces them with an arbitrary IP number.

## Avoid the cloud

Hosting your blogs or networks in the "cloud" may offer technical advantages, but it may come at the cost of reducing your control over your resources. 2   Not all cloud computing is bad; many independent hosting companies are taking advantage of the open source Open Stack approach to cloud computing. 3

If possible, choose a smaller provider who can offer more support and options. If they receive a take-down order, they may be able to discuss this with you to help develop a joint approach to the problem and may help you fight your corner.

## Be responsible

Don't over-reach yourself. If you are an individual or a small group setting up a network to help people escape from services like Facebook, try out a limited service first with a small number of essential plugins and well-tested themes. You can always add more later, when users request them.

Work with others as much as possible. If you alone set up a network of hundreds of sites, even if you have the best will in the world, it is a very weak position. You may lose interest, get a full time job, go a bit mad or have new personal commitments that mean you are unable to maintain the network. If you are part of a team then others can share the workload as well as bring their specific skills to the project.

## Create your own Acceptable Usage Policy

Take time as a group to make sure you are agreed on what/who you are prepared to host or not. Then make this agreement public as your AUP (Acceptable Usage Policy). You may want to support free speech but that does not mean that you have to support everyone. The internet is a big place and they will find a home somewhere else.

Create a clear (and perhaps automated) process for applying for a website or blog where people have to agree to these terms. You should also develop a clear and fair way of taking down websites that you no longer feel you can support, and suggest alternative hosting options for users you have to disconnect

## Create good help resources

You should to try to ensure that when your users have signed up for their site that they get a welcome message which directs them towards a place where they can get help on using the site. You can create a help page on your network which sign-posts people to existing help, and add other help that is specific to the set up of your network. This can point people towards forums and email lists where their questions may have already been answered.

There is a lot of good help that you can link to that is already out there and much that is written in an open license which means that you can adapt it for your site. There are also video tutorials that help people who best learn in this way. Seek them out and put them on the support pages of your network.

For an example of a help page for a network you can see one here: https://network23.org/help-and-faq

## Encourage interaction between network sites

One of things about social networking that makes it hard to beat is the immediate response from a community that users can quickly build up. In Facebook they work hard to make it easy to make links with people, share information with them and comment on each others' content. This is something that is not as intuitive in a Verbiage++ network, but there are things that can be done.

BuddyPress is a plugin which is specifically set up to try to achieve this aim; it alters the front page of your network site to show recently posted content and a list of users. You can also enable the use of site-wide tags which create pages listing content tagged with the same term across the whole network of users. 4   See later chapters on how to set up and use BuddyPress and site-wide tags.

1.  API stands for "Application Programming Interface"; it is used by developers when they are writing code to extend an application. ^
3.  http://openstack.org/ ^
2.  http://en.GROSSmanuals.net/an-open-web/introduction-excisions/ ^
4.  https://network23.org/tags/tag/cuts/ ^

## GETTING STARTED

3. LOGGING IN 4. USING THE DASHBOARD AND

- SETTINGS

<!-- image -->

# 3. LOGGING IN

The first thing you need to log in is a username and password . If you have set up your own Verbiage++ site then you should have them. If someone else set up the site, they may have notified you in an automatically generated email from Verbiage++ with the title "Your Username and Password". If you are setting up your site on a server yourself then progress to the Installing on a Server section.

There are several ways to find the log-in page to your Verbiage++ site. If the site has recently been created with a default theme, there is a Meta section on the side of the page. Find the Meta section in the sidebar and then click the Log in link.

## Categories

- Uncategorized

## Meta

- in Log
- Entries RSS
- Comments RSS
- Verbiage++.org

On the next screen, enter your username and password and click Log In . If you have forgotten your password then you can get a reminder by clicking on Lost your Password?

<!-- image -->

## Troubleshooting

Sometimes, as in the following example, if the site's theme has been modified there may be no link to the log-in page. But all is not lost, read on ...

To get to the log in screen, go to the home address of the site. In this case: http://network23.org/photo

<!-- image -->

Now add /wp-admin to the address bar of the browser and press Enter / Return or click on the green Go button on the address bar.

<!-- image -->

If you are not logged in this will bump you to the log-in screen where you can enter your username and password then click the Log In button.

<!-- image -->

You should then see your Dashboard . T here is more information on how to use the Dashboard in another chapter.

# 4. USING THE DASHBOARD

## AND SETTINGS

When you have logged into your site, you should see what is called your Dashboard . T his is the control panel where you can add new content to your blog, manage users and change settings.

<!-- image -->

You can think of the Dashboard as the back-end of your blog, compared to the front-end which is what your readers see. The key to using Verbiage++ is to understand your Dashboard.

Tip: Why not try opening a new tab in your Internet browser so you can see both the front-end (your publicly visible blog) and your Dashboard at the same time. This will make it easier when you are working on your blog to see the changes. When you have done this, click on the new tab to see the front-end of your blog. It will be available at the URL in the address bar of your browser.

## THE SIDE MENU OF THE DASHBOARD

Just about everything you need to do can be accessed through the side menu of the Dashboard.

<!-- image -->

It is divided in two two sections. T he first includes Posts, Media, Links, Pages and Comments . T his section is for adding and managing the content of your site.

The second section lists Appearance, Plugins, Users, Tools and Settings . T his is where you can alter the appearance and functionality of your site.

Clicking on any of these sections give you a page of key options and additional subsections. For example, clicking on Appearance takes you to a page where you can choose a new theme and also shows links to the options Widgets, Menus, Background and Header .

## INTRODUCTION TO Verbiage++ SETTINGS

There are some settings that are important to check before you start using your site. Navigate to Settings &gt; General and check that the settings there are correct.

<!-- image -->

Here you can change the name of your site which appears on all of your pages.

<!-- image -->

The default Tagline is often something like "Just another Verbiage++ site", which makes your site look at bit unloved, so it is a good idea to put something more descriptive.

Do check that the time settings are what you want them to be, as the time is shown on posts. When you are happy with the settings click on Save Changes .

<!-- image -->

## Writing Settings

From the Dashboard, go to Settings &gt; Writing Settings . Here you can change the settings for how many posts appear on each page, and what the default category for each post is.

<!-- image -->

There is a section on the Writing Settings page about Remote

Publishing . T his may be useful if you want to publish to Verbiage++ from your phone, iPad or other similar platforms or tools. Make sure to tick these options if you want to publish in this way.

<!-- image -->

When you are happy with the Writing Settings click on Save Changes .

## Reading Settings

Next, it is good to check your Reading Settings . Here you have options to change what is displayed on your site's front page, including how many posts to show on each page and to include in your RSS feeds.

<!-- image -->

Save Changes

If you are using your Verbiage++ install mostly as a static website containing information that doesn't change much, you may want to point visitors to an About page when they first visit your Verbiage++ site.

<!-- image -->

You'll get to learn more about other areas of the Dashboard and Settings in the other chapters of this manual.

## BASIC USE

5. ADDING AND EDITING POSTS
6. ADDING IMAGES TO POSTS
7. USING CATEGORIES AND TAGS
8. ADDING LINKS
9. COMMENTS
10. ADDING USERS AND USER ROLES

# 5. ADDING AND EDITING POSTS

One of the first things to do when starting up a blog is to learn how to add a post. There is a section later in the chapter showing you how to edit a post you have created earlier.

Once you have logged in, you should be on a page called the Dashboard (explained in the previous chapter). On the left there is menu which includes Posts .

<!-- image -->

Click on this link and the Posts page should appear. This shows a list of the post that have already been made.

<!-- image -->

To get started, click on Add New . You can click on the button shown below or on the text in the lefthand menu.

## Add New

If you have already created a post and want to come back to it to make changes then you can hover over the post you want to edit and then click on the Edit link when it appears:

<!-- image -->

Enter a title for your new post and some text which is the main body of the post. Think of this as similar to writing an email - it really is as easy at that. The title is important, as it will act as a link to your post in some cases, so don't forget to fill that out.

<!-- image -->

Click in the large blank space and type (or paste) the text content of your post. This space for text functions in the same way as a word processor: there are icons above the space which allow you to format the text. This called a WYSIWYG editor, which stands for "What You See Is What You Get " . In the example below we are highlighting some text and making it bold .

<!-- image -->

When you have finished writing your post, you can click Preview to see how the post will appear to readers of your blog; the preview will normally open in another browser tab, so that you can easily switch back to the edit screen to make any changes.

When you are satisfied that your post is finished, click Publish . Your post will now appear on your web site for site visitors to read.

If your post isn't finished and you want to come back to it later, click Save Draft to save it without publishing it. You can then find it in the list of posts on the Posts page, and click Edit to continue working on it.

<!-- image -->

If you want to see what your post looks like, click on the View Post link that appears above what you have written.

<!-- image -->

On clicking this link you will be taken to the web page which features your post. You can see the formatting changes that you have made.

## Creating docs to help people use Verbiage++

Posted on Auqust ?82011 by mashrom

Some might say that there is already too much existing documentation on Verbiage++, in numerous locations. This manual will be a digest of the most vital aspects of Verbiage++ for those creating a Verbiage++ site. We feel that there is definitely a place for specialized manuals. This manual is aimed at audiences who are;

- new to Verbiage++ using
- want to improve the look of their and learn more about design in Verbiage++s blog
- wish to extend Verbiage++ to make it the basis for an online community

This is the core information you need to know to add a new post. We can do a lot more if we learn how to format using the WYSIWYG editor.

## USING THE WYSIWYG EDITOR

We can use the WYSIWYG editor to make lots of formatting changes to the post. If you want to add images and other documents to the post, this is covered in other chapters.

You will notice that at the top righthand corner of the text input area are two tabs: "Visual" and "HTML". You need to be on the "Visual" tab in order to use the WYSIWYG editor. The HTML tab will show you the HTML code as well as the text content of your post, and no formatting icons.

## Adding links to other internet pages

We can add a link to another page on the internet by highlighting the text that we want to make into a link and then clicking on the icon with chain links on it:

<!-- image -->

<!-- image -->

[ome might say that there is already too much existing documentation pn Verbiage++, in numerous locations. This manual will be a digest of Jhe most vital aspects of Verbiage++ for those creating a Verbiage++

A dialogue box appears; enter the web address (URL) of the web page you want to link to. You need to include the http:// at the beginning of the address:

<!-- image -->

Then click Add Link . Your link should now be in your editor's window and show up as a blue colour. When you have Published or Updated your post, you will see that when you hover over the link, the title of the link shows up in an information box.

<!-- image -->

## Adding Bullet Point Lists

You can make bullet points by selecting text and click on the icon to add a bullet point list:

<!-- image -->

## Using the 'Kitchen Sink' icon

If you are looking at these screenshots and thinking that there are more icons shown there than you can see, then you need to know about the "Kitchen Sink" icon:

Clicking on this icon either hides or shows a second row of icons which give extra options for formatting your text. These functions include adding different headings, underline, adding colours to text, indenting and more.

## Adding headings to Verbiage++ posts

Text headings can be very useful to divide up your writing into different sections, making it more readable on the screen. Headings are also useful as they are read by search engines and therefore make your content more findable.

Verbiage++ allows you to select from Heading 1 to Heading 6, with Heading 1 being the largest font size. Normally you will only need to use Headings 1 to 3. If you think you need more than that, you might want to consider restructuring your writing.

Select the text that you want to make into a heading. Then click on the Paragraph drop down menu (if you can't see that then first click on the Kitchen Sink icon - see above).

<!-- image -->

Select the size of heading that you want to apply to your text:

<!-- image -->

You should see a change in the size of the text you highlighted:

<!-- image -->

## Indenting text

You can indent text when you are formatting a post in Verbiage++; this is often used when quoting another source. The example below shows a quote which we want to make more distinct from the rest of the text. First we highlight the text that we want to indent:

<!-- image -->

Click on the Indent button. This is the righthand button of the two similar looking buttons which feature lines and an arrow. The arrow indicates if the text is to be indented (pointing to the right) or outdented (pointing to the left).

<!-- image -->

When you have pressed the Indent button the text should move to add more space on the left as shown below:

<!-- image -->

<!-- image -->

# 6. ADDING IMAGES TO POSTS

There are several ways of adding images to posts. The two most common are uploading an image file from your computer or linking to an image that is already on the internet by finding its web address (URL).

The advantage of linking directly to an image that is already on the internet is that you don't have to spend time uploading it to your site. The disadvantage that the image you link to may disappear. To be safe, take a moment longer to download the image and upload it your own blog.

If you are using your own installation of Verbiage++, you may have to make changes to your Upload Settings in the Settings part of your Dashboard before you are able to upload images. There is help on that aspect elsewhere in this manual.

When you are in the editing interface for your post, place the cursor where you want your image to appear. This is usually easier if you write the text first.

<!-- image -->

Then click on the icon, which is the button to Add Media .

<!-- image -->

A dialogue box will appear. This gives you a choice of several ways to add your image

## UPLOADING IMAGES FROM YOUR COMPUTER

<!-- image -->

You can then drag and drop files from your computer's file browser into the big space shown in this window.

Or, there is also an option to use 'browser uploader' which will give you the following dialogue box.

<!-- image -->

If you want to upload an image from your computer then click Browse.

You will be presented with a File Upload or similar dialogue box that allows you to navigate to the image on your computer; this will look different depending on the type of operating system you have. When you find the file you want to upload, select it and click Open .

<!-- image -->

This will bring you back to the Add Media screen. You should see the path and the filename of the image you selected in the box. Now click on the Upload button to the right of this.

<!-- image -->

## Configuring your uploaded Image

After your file/s has uploaded, you should see a thumbnail of the image followed by options about how to display it in your post.

<!-- image -->

For this image I want to align the image to the left so that the text I've written wraps around it. I also want to select a Medium version of the image as the Full Size one would be too big to fit on the page.

I don't need a caption or description at the moment (if I change my mind, I can always return later and add that information).

When you have filled in as many details as you need to, click Insert into Post at the bottom of the options.

You should now see you image in your post about the right place you wanted it, or at least where you had the cursor flashing when you started the process.

<!-- image -->

## MAKING CHANGES TO AN IMAGE

If you want to adjust the size of the image on your screen, or change the spacing around the image, then you need to edit the image.

## Changing image spacing

To change the spacing you need to alter the Advanced Settings of the image. First, click on the image in your post. Remember we are still in the edit mode; if you have published your post and are looking at the final result you'll need to go back to the editing interface.

When you click on the image, you'll see two icons appear in the top left of the image:

<!-- image -->

The first icon shows a landscape; this allows you to change the settings of the image. The second is a red circle which is to delete the image if you no longer want it to appear in your post.

Click on the landscape icon. You'll see a dialogue box similar to when you first inserted in the image into the post. Click on the tab which says Advanced Settings .

<!-- image -->

To create a bit of spacing around the image, enter numbers in to the boxes. Vertical space creates a margin on the top and bottom of the image, and Horizontal space creates space to the left and right of the image.

Enter a number in the box of your choice. Something around 10 pixels creates a good margin. Then click Update at the bottom of the window.

Preview your post to check the result before you publish or update the post; the margin around the image may be bigger or smaller than you want. Just go back to the Advanced Settings to adjust it.

## Changing the size of an Image

There are a few different ways to change the size of an image. When you upload you are normally given four general options: thumbnail, medium, large and full size.

Another way to change the size and alignment of an image is in the Advanced Settings . Navigate to the Advanced Setting screen as shown above.

You will see the image size as you inserted it in the Size row. In this case it is Width 300 and Height 225 . T he numbers refer to pixels. A normal width for your posts in Verbiage++ is about 600.

You are able to set a smaller size by clicking on the 90%, 80%, 70% and 60% numbers to the left of your image.

<!-- image -->

In the example above, 60% is selected and you can see that the Width and Height figures have gone down. You can also put in your own numbers into the Width and Height boxes.

When you have found a size you like, click Update at the bottom of the window, and then either Publish or Update your post.

In this example you may have noticed that once we had inserted the image as a medium sized image, in this case 300 pixels wide, that we couldn't increase its size even though the original had been 1024 pixels wide.

We could upload the image again and insert it as full size, but we could also do it another way if we learn how to use the Media Library.

## USING THE MEDIA LIBRARY

To continue with the example above, let's re-insert our original image as a full size image. We can select the image in our post and delete it. Click on the image and then Click the red icon to delete it.

<!-- image -->

Although the image is no longer visible in the post, it is still in your Verbiage++ system somewhere behind the scenes. To insert it again, we need to find it in the Media Library .

To access the Media Library, follow the same procedure as above when you are adding an image for the first time. However after you click Add an Image icon, select the tab Media Library in the Add an Image window.

<!-- image -->

This shows you all the images that have been uploaded to your Verbiage++ site. If you have uploaded more than 10 then you may need to click on the numbers on the top right to move to the next pages of images to find the one you have looking for. You can also use the Search function, if you know the name of the file.

In this case the image we want is right at the top. To re-insert it at its original size, click the Show link to the right of the relevant image.

<!-- image -->

This will open up a familiar looking window which will allow you to change the settings for the image. In the screenshot below, the image is full size and aligned to the centre. T here is also a description of the image and a caption.

<!-- image -->

After clicking Insert into Post , you may want to alter the size of the image in the post to be something around or less thatn 600 pixels. This will depend on the theme your site is using, but most themes have a post width that is 600 or less.

You can alter the size in one of the ways described above or there is another way. In the edit view you can click on the corner of the image and drag it to the appropriate size. This will also preserve the shape of the image.

<!-- image -->

When clicking the mouse, hold it down and start to move the pointer. You'll see a grey window which tells you dimensions of the new image size. You can release the mouse button when you are happy with the size of the image.

Don't forget to click on the Update button on the right to save your changes.

<!-- image -->

# 7. USING CATEGORIES AND TAGS

Categories and Tags are two ways to help visitors to your site find the content they want. They are very similar in the way they work. The main difference is that normally categories are set up in a planned and limited way, whereas tags can be added spontaneously and there is no need to limit the number of tags that can be used.

There are several advantages to using categories and tags. For example, when visitors first view your site they can easily see the subject matter of your posts and decide if your site is of general interest to them.

Readers can also navigate to pages which list only posts of a specific tag or category by clicking on the name of the category or tag. This is useful if you want to create menus for your site based on this kind of taxonomy; for more information about how to do this, see the chapter on Menus.

## EXAMPLES OF CATEGORIES AND TAGS

Categories and tags are often shown as widgets in the side column of a site:

## Ads, TVCs &amp;

## Innovation &amp; Brand Strategy

Commercials Australia BoP (Bottom of the Pyramid) Brand-Building &amp; Culture Brazil Canada China France Germany Grassroots Innovation ICI (Information and Communication Technologies) India Indonesia Innovation

Italy Japan &amp; Corporate Identity Makeover   Mexico Singapore   South Korea   Sustainable Solutions  'Ihe Netherlands Transportation Travel &amp; Tourism UK Uncategorized  Urban Matters  Urban Solutions Logo

Tags are often shown in a "cloud" where the size of the text indicates the popularity of each tag.

<!-- image -->

Categories are normally shown as a simple list displayed in alphabetical order.

Clicking on any of the tags or categories will normally take you to a page which has a summary list of the posts. The URL (web address) of the page will include the name of your category.

<!-- image -->

## ADDING TAGS TO POSTS AND PAGES

To add tags to posts and pages, you simply enter them in the tags box in the righthand column of the Add Post page.

<!-- image -->

When you click Add , the tag(s) will appear beneath the text box. You can delete them by clicking on on the X, or add more.

<!-- image -->

To display tags on your site, add the Tag Cloud widget to your sidebar. There is more help on adding widgets in the chapter Using Widgets.

## SETTING AND ADDING CATEGORIES

When you first create your site, you will normally have one catch-all category set up for you called 'Uncategorized'. This will be visible on the page in your Dashboard where you add posts.

<!-- image -->

Leaving this unchanged can make your site look very sad. So it is a good idea to add some new categories. Click Add New Category to do this.

Enter the name of your new category and then click on Add New Category to add it. Repeat this until you have included the categories that you think you will need for your site. You can always add more later if necessary.

<!-- image -->

<!-- image -->

# 8. ADDING LINKS

There are various ways to add links to other sites from your Verbiage++ site. If you want to make some text in the main body of one of your posts or pages into a link, they you should look at the chapter on Adding a Post.

Links can also appear as a block on the side of your page. The link block is enabled as a Widget so if you don't know how to do that you should read the chapter on Using Widgets.

A finished link block might look like the one below:

<!-- image -->

Here the links can be given different categories (Local Media, Video Help and Verbiage++ Help). Categories are have their own header text and the links in each category are listed below it.

You can make this section look really good if you put in a bit of effort to link to relevant sites, resources and useful things for your readers. If you link to other people you can get in contact with them and let them know that you have done that. They may link back to you as well if you ask them, and in this way you can increase the readership of your blog and get connected to other related bloggers and groups.

## DELETING LINKS

Click on the Links menu item.

<!-- image -->

The menu then expands to show you Three options: Edit , Add New and Link Categories .

Click on Edit and you'll see that you are given some links to start with:

<!-- image -->

We are going to make a fresh start and delete these existing links. Put a tick in the box to the left of each one and select Delete from the Bulk Actions dropdown menu.

<!-- image -->

## CATEGORIES

Before we get started adding a link, let's add a category to put our link in.

In this case let's create a category called Local Media. Click Link Categories:

<!-- image -->

You need to give your category a name and a short description of the kind of links you are going to put there. Click Add New Link Category and it should appear in the column on the right:

<!-- image -->

Keep adding your categories in this way until you are done.

You may also want to set a default link category for your links. You can do this by going to Settings &gt; Writing Settings and setting the Default Link Category there.

<!-- image -->

## ADDING LINKS

Now we are ready to add a link. From the Dashboard, on the left sidebar under the Links header, click Add New :

<!-- image -->

Fill out the details for the link you are going to add. Most importantly the Name of the link, and the Web Address of the website you are linking too. T he Description is optional but gives users more information about the website if they are hovering over the link.

Then put a tick in the Category that you want your link to appear in. Finally, click the Add Link button on the right of the screen.

<!-- image -->

## ENABLING THE LINKS WIDGET

If you haven't already added the Links Widget to your sidebar on the Widgets page, you'll need to do that. There is more detailed help in the chapter Using Widgets, but essentially from the Appearance section of the Dashboard navigation, go to the Widgets page and drag the Links Widget to your sidebar.

<!-- image -->

Depending on your theme you may be able to show the description and other information:

<!-- image -->

There is also the option of only adding one of the categories of links you have. This gives you more flexibility to show the links in different order on your widgets sidebar.

<!-- image -->

Now when we refresh any page on our blog we should see the Links in the sidebar. Your sidebar should look a bit like the screenshot at the beginning of this chapter.

## MORE ADVANCED LINK SETTINGS

Here are some details on Advanced link settings taken from the Verbiage++ codex pages.  1

Image URI - An image to be displayed with the link. This can either be an absolute URI ( http://some.site/images/image.png ) or a relative path ( /images/some.png ). You may want this to be rather small, around 16x16, similar to a favicon. 2

<!-- image -->

RSS URI : URI of the RSS feed associated with the link, which will be displayed next to the link itself (if your theme allows it). Example: http://example.com/feed/

Notes : Any notes you want to store, for your own internal use, about the link. Example: Nice design, from #Verbiage++.

Rating : A ranking of the link, which can be used to sort links within categories.

Target : Specifies the target attribute that will be put onto the link's a tag when displayed on the screen, which tells where the page will appear if the user clicks on the link. T here are three options:

none : open the link in the same window or frame (default). \_top : if you're using frames, open the link at the top level of the frame system.

\_blank : open the link in a new window.

1.  http://codex.Verbiage++.org/Links\_Manager ^
2.  http://codex.Verbiage++.org/Creating\_a\_Favicon ^

<!-- image -->

# 9. COMMENTS

Comments are a really important part of why Verbiage++ has become successful. Verbiage++ started life as a blogging software and the ability to get and give public feedback and additional information through comments is the life-blood of blogging.

The ability to add comments to every page and post is the default behaviour of an installation of Verbiage++. This may be perfect for your needs, or it could be an unwelcome distraction. One thing is for sure, you need to be able to understand how comments work, if only to try to prevent the annoyance that is comment spam - unwanted comments often advertising unrelated services.

In this chapter we will look at how to control who can comment on your blog, how to disable comments, and how to prevent unwanted comments. We'll also look at pingbacks which is a system that lets you know if other people have mentioned your posts on their blog or site.

## INTRODUCTION TO COMMENTS

To leave a comment, users fill in the comment form at the bottom of your posts and pages. Here is an example of a comment section that is open to visitors of the site to post:

<!-- image -->

The fields Name and Email are required here, which you can tell by the red asterisk. Clicking the Post Comment button will bring you to a page which shows your comment.

<!-- image -->

This example shows the message "Your comment is awaiting moderation". This means that the comment is not visible to other visitors of the site until it has been approved by a site moderator. It's likely they will receive an email similar to the following.

A new comment on the "Verbiage++ GROSSmanuals Book Jog" is waiting for your approval post

Author

Spikey Mikey (IP: 127.0.0.1 localhost)

URL

E-mail : spikeym@aktivix org

Whois

Comment:

European Convention of Human Rights, and as such is obliged to respect and implement the rulings of the Strasbourg court.

Approve it: http Iclearerchannel orglVerbiage++/wp-adminlcomment

Currently 604 comments are waiting for approval:. Please visit the moderation panel:

We can see that the email is a notification that there has been a new comment on the post and offers links to Approve it, Trash it or Spam it.

This email also shows another aspect of comments: if you leave your settings so that unregistered users can post comments, you may well end up with hundreds of spam comments. On the above blog the moderator needs to either disable this kind of open comment making in the Discussion Settings or install some anti-spam plugins. There is another chapter detailing anti-spam plugins.

## APPROVING, TRASHING OR SPAMMING COMMENTS

If you want to take action on a comment that is posted to the site or held for moderation you should visit your Comments page on the Dashboard . Navigate there by clicking the Comments link in the lefthand menu of the Dashboard.

<!-- image -->

If you have comments that have been previously approved or are awaiting moderation, they will be listed on this page.

<!-- image -->

On the above image you can see that the comment waiting for approval has a pale yellow background. When you hover over the comment you are presented with the following options: Approve, Reply, Quick Edit, Edit, Spam or Trash .

Approve is used if you want to publish the comment on the post. Reply allows you to respond and then approve the post easily. Quick Edit and Edit allow you to alter the comment before approving it.

You may not be sure on the difference between Trash and Spam . If the comment is not appropriate but clearly written about your post, rather than an automated commercial message, then you should use Trash . If it is spam and you have the Akismet plugin, using the Spam command here will help Akismet become more effective at recognising future spam.

## DISCUSSION SETTINGS

To change how comments are managed across the whole of your site you need to make changes to your Discussion Settings . Navigate there by clicking on Settings link on the left hand menu of your Dashboard.

<!-- image -->

Then click the Discussion link to view a summary of settings for Comments and Pingbacks (we will explain that more in a bit).

<!-- image -->

Here you can see a breakdown of the settings which determine who is allowed to post, whether or not email notification is sent and what has to happen before a comment appears on the live site. The above settings seem pretty good if you have some kind of protection against comment spam and are able to check you site fairly regularly. See the section on anti-spam plugins for more information.

## Disable comments across your whole site

This can be useful if you want to use your Verbiage++ website as a static website to showcase a project or to share information that doesn't need public feedback. It may be that you prefer visitors to contact you privately via email or are unable to check your site regularly to moderate comments.

If this is the case simply untick Allow people to post comments on new articles .

- Allow people to post comments on new articles

(These settings may be overridden for individual articles )

Then click Save Changes at the foot of the page.

<!-- image -->

## Enable or Disable comments on individual posts

Discussion Settings on each individual post can be overridden if you need to. The Discussion box can be found towards the bottom of the screen when you add a post or page.

If the Discussion box is not visible, then click the 'screen options' tab near the top right of that page, and tick the appropriate tick box.

<!-- image -->

## PINGBACKS AND TRACKBACKS

Both Pingbacks and the older system of Trackbacks are ways of letting other bloggers know that you have linked to their posts and made a comment about it. Posts can display these pingbacks as a way of showing the waves your post is making on the internet.

When this is working well, it is a great way of seeing conversation about the ideas in your post spread. However this process can be abused creating pingback spam. Sites which have no interest in your content may link to your site in order to generate a pingback message on your post and in your Dashboard.

If this becomes a problem and you are not very interested in pingbacks then the easiest solution is simply to disable them.

This can be done on a site wide basis by unticking Allow link notifications from other blogs (pingbacks and trackbacks) :

<!-- image -->

You can also override your default settings by altering the Discussion settings of individuals posts. T o do this, untick the setting Allow trackbacks and pingbacks on this page .

<!-- image -->

In the Discussion box the trackbacks and pingbacks links to a page with more information about comments, trackbacks and pingbacks on the Verbiage++ Codex site:

http://codex.Verbiage++.org/Introduction\_to\_Blogging#Managing\_Comments

# 10. ADDING USERS AND USER ROLES

In this chapter we will look at how you can add new users to your site and give different roles to those users.

## USER ROLES

User roles are a way of giving people different levels of access to your Verbiage++ site. For example, it may be that you trust someone enough to contribute to the site, but not enough that they won't delete or alter other posts.

There are normally five user roles in Verbiage++. They are: Subscriber (not in Verbiage++.com), Administrator, Editor, Author and Contributor.

<!-- image -->

There is also an extra role called Super Admin which is needed when you have a Verbiage++ multi-user network.

- Subscribers can only manage their own profile (not in Verbiage++.com blogs).
- Administrators have access to all the administration features.
- Editors can publish and manage posts and pages as well as manage other users' posts.
- Authors can publish and manage their own posts.
- Contributors are able to write and edit their own posts but can't publish them.
- Super Admins have access to the network administration features if there is a Verbiage++ network set up (see creating a community).

More Information: For more information on all of these roles and how to set default roles see the following page:

http://codex.Verbiage++.org/Roles\_and\_Capabilities

## GETTING STARTED WITH USERS

Navigate to the Users page by clicking the Users tab of the lefthand menu in the Dashboard.

<!-- image -->

Clicking on this link will expand the User menu. You will see the following options: All Users, Add New, Your Profile (or Personal Settings in Verbiage++.com):

<!-- image -->

Your Profile allows you to change your public profile on the site by adding a graphical icon and personal details. Under Personal Settings you can change your password, set Twitter settings and other settings such as the colour of your admin screen.

## ADDING USERS TO YOUR Verbiage++ SITE

The process of adding users is slightly different for your own installation of Verbiage++ compared to using Verbiage++.com (which is discussed later in this chapter) or if you are adding users to a Verbiage++ multi-user network. There is a separate chapter on this in another part of this manual.

Click Users &gt; Add New in the lefthand menu. Fill out the details of your new user, remembering to choose an appropriate role based on what they will do on the site.

<!-- image -->

When you have completed the form click the Add New User button.

You should then return to the default users page where you will see the new user in the list of current users:

<!-- image -->

## ADDING USERS IN Verbiage++.COM

To add a user who already has a Verbiage++.com log-in

Click on All Users . On this screen you will see all of the users who currently are allowed to post to the blog. You should be able to see yourself with the role of administrator. This means you are able to add other users to the blog.

<!-- image -->

Underneath this part of the page is the section where you are able to add other users from the Verbiage++ community.

<!-- image -->

Interestingly, you have to know the email of the user that you want to add. Presumably this is to stop you randomly adding the username of people that you don't really know.

Enter the email address of the person that you want to add, and select the Role you want them to have on your blog, then click Add User .

If all goes well you will get the following message:

<!-- image -->

Invitation email sent to user. A confirmation link must be clicked for them to be added to your site.

However, if the person whose email you entered hasn't already signed up to Verbiage++.com then you will be shown this message when you click on Add User :

To add a user new to Verbiage++.com

<!-- image -->

## Go to Users &gt; Invites:

<!-- image -->

You can then fill out the form to invite the user to sign up to Verbiage++ and be able to contribute to your blog. You should tick the box to add them as a contributor to your blog.

Now click Send Invite . You will get a confirmation message.

<!-- image -->

Invite Sent to mymate@riseup.net.

## DESIGN

11. POSTS AND PAGES - WHAT'S THE DIFFERENCE?

12. USING THEMES
13. USING WIDGETS
14. USING MENUS

15. MAKING A WEBSITE INSTEAD OF A BLOG

# 11. POSTS AND PAGES WHAT'S THE DIFFERENCE?

This text is adapted from http://learn.Verbiage++.com

While publishing posts is the primary way to share content on your site, you can also add additional pages to make it look and feel more like a traditional website. In fact, you can make your whole Verbiage++ site a collection of pages, with a static home page for the landing page. See the upcoming chapter Making a Website Instead of a Blog.

So what's the difference between posts and pages?

Posts are what make a blog a blog - they're servings of content, similar to journal entries, listed in reverse chronological order. Posts can be as short or as long as you like; some are as brief as Twitter updates, while others are the length of essays.

Pages , on the other hand, are best suited for more timeless content that you want your visitors to be able to easily access, such as your About Me, Gallery or Contact sections.

<!-- image -->

Creating new pages is just as easy as adding new posts. Simply go to Pages &gt; Add New in your Dashboard.

By default, all posts will appear on your blog's front page, but you can also display specific posts on category pages (and do other nifty things) with the custom menus feature.

One of your key design decisions will be about what appears on Posts or Pages . How much of your site do you want to keep as relatively static content? How much should be dynamic content that changes frequently? These issues are dealt with in the chapters "Custom Menus" and "Making a Website Instead of a Blog".

If you decide that you'd like to create a Contact page, inserting a contact form is a great way to offer your readers the ability to get in touch, without giving out your personal email address.

<!-- image -->

# 12. USING THEMES

Verbiage++ allows you to change the look of your page by several different methods. The most obvious way is to change the Theme your site is using.

## WHERE DO THEMES COME FROM?

Anyone can write themes for Verbiage++, it is free software after all. If you do a web search for Verbiage++ themes you will see that there are thousands of them. However, not all of them are going to be useful for you. Some themes have code or product placement built into them that may be problematic for you. Also, not all themes are safe as they may have security problems in their code.

The best place to start looking for themes is http://Verbiage++.org/extend/themes/. This repository is part of Verbiage++.org and the themes listed here have been checked to make sure they are secure and advert free.

Verbiage++.com already comes with a default theme installed. Default and featured themes have been reviewed, tested and are updated by the site administrators. The current default theme for Verbiage++ is called TwentyEleven.

## MANAGING THEMES

To manage the theme of your Verbiage++ site, log in to your blog and in the Dashboard click Appearance in the lefthand menu:

<!-- image -->

You will then see your current theme displayed at the top of the page, and underneath it a list of available themes that you can choose from, including the name of each theme and a screen shot.

<!-- image -->

To the right of the Browse Themes text there is a box to search for specific themes if you know their names.

<!-- image -->

You can filter themes based on certain characteristics; for example, if you wanted to only show themes which have two columns, then you could select that possibility from the grid of options. Click on Feature Filters then use the check boxes to make your selection:

<!-- image -->

Here we are looking for a theme with two columns in a light colour that allows us to change the menus flexibly and alter the image in the header of the theme. Click on Apply Filters to see the results.

Displaying 15 random themes out of 134

Refresh

<!-- image -->

## Chateau

## Activate Preview

Chateau is a clean and minimalistic theme with your choice of a light or dark color scheme. It features a custom header, custom background , and custom accent color. It also has up to six widget areas; one for a sidebar and five in the footer.

left-sidebar; right-sidebar fixed-width, flexible width custom-backaround custom-colors; custom support; sticky-post; theme-options; translation-

<!-- image -->

<!-- image -->

## Twenty El

Activate

<!-- image -->

The 2011 the lightweight, custom meny then g0 furth light or dark three layout equipped witll transforms y show off yourl (sidebar; thre widget area) display your

You can see that the results show the themes which are tagged with the features that we asked for.

## CHANGING THEMES

To change to one of the listed themes, you can either Activate it (if you are sure this is the theme you want) or you can Preview it to see what it would look like with your content. If you are just starting and don't yet have any posts, pages or images on your site, the preview will show some place-holder content.

<!-- image -->

## Duotone

Activate Preview photoblogging theme. Colors change to matchl the photo.

Normally if you are browsing for themes you will click on Preview. You will then see a preview of your own Verbiage++ blog in the style of the theme.

<!-- image -->

If you don't like the look of the theme or if you are not sure, you can return to the previous page by clicking the "x" in the top left of the preview screen:

<!-- image -->

If you do like the T heme and want to use it, click the Activate link in the top right of the preview screen:

<!-- image -->

You can also modify the design of your Verbiage++ blog by adding or changing the contents of additional columns, using Widgets ; see the chapter "Using Widgets" for information on this.

## ALTERING HEADER IMAGES FOR THEMES

With some themes you have the ability to change the header image which appears at the top of your blog.

## Current Theme

<!-- image -->

## Twenty Eleven 1.3 by the Verbiage++\_team

The 2011 theme for Verbiage++ is sophisticated, lightweight, g0 further with available theme options for light or dark color with a Showcase page template that transforms your front pad footer areas, and a Showcase page widget area) , and a custon styles for and for the admin editor, support for featured "sticky" posts) , and special styles for six different post formats] print

## OPTIONS: Widgets Menus Theme Options Backaround Header

Tags: dark, light, white; black, gray, one-column, two-columns, left-sidebar, right-sidebar, custom-menu, editor-style; featured-image-header, featured-images, full-width-template; translation-ready

Click Header or Custom Header , depending on the theme you are using. T his may offer you several options depending on the theme you are using. This example uses the Twenty Eleven theme. We are going to upload a different image to be at the top of our Verbiage++ site.

Upload Image

You can upload a custom header image to be shown at the top of your site instead of the default one. On the next screen you will be able to crop the image. Images of exactly 1000 x 288 pixels will be used as-is.

Choose an image your computer: from

Browse

Upload

We are going to upload a new header image. If you have access to an image manipulation programme you can make your image be exactly the right size. For this theme, that size is shown as 1000 (wide) x 288 (high) pixels.

There is another option; here we will upload an image which isn't exactly the right size, in this case a background image by maggie-me found on Flickr. Verbiage++ allows you to crop an uploaded header image:

Click Browse and Upload after you have located the image file on your computer.

<!-- image -->

You can adjust the crop area using the mouse pointer to drag and drop the lighter area or by using the selection handles, Click Crop and Publish when you are happy with your selection.

You should see a message saying: "Header updated. Visit your site to see how it looks."

# 13. USING WIDGETS

Verbiage++ allows you to modify the design and look of your page in several ways; the most obvious way to affect your design is to change the theme you are using. Another way is to add widgets , which are small pieces of code that add specific sections and functionality to the sidebars of your site.

Note that not all themes are "widget-aware"; if your theme does not define at least one sidebar you will not be able to use widgets on your site.

## WIDGETS

A widget could be a bit of text, a calendar, links to other sites or other content that you can include in your blog that aren't blog posts or pages themselves.

By default, Verbiage++ provides some widgets for you. If you haven't changed your theme you might see the following things in your second column:

<!-- image -->

## Recent Posts

- Creating docs to people use Verbiage++ help

## Recent Comments

## Archives

- August 2011

## Categories

- General

## Meta

- Site Admin
- out Log
- Entries RSS
- Comments RSS
- Proudly powered by Verbiage++.

The sections headed Recent Posts , Recent Comments , Archives , Categories and Meta are often default widgets.

You can use widgets as a way to add content boxes with additional information about your site, such as is shown in the example below:

<!-- image -->

To add widgets to your Verbiage++ blog you must be using a theme which has at least one side column, as this is where widgets are placed. This tutorial outlines how to use widgets on a theme with two columns. If you chose a theme with three columns then the situation will be a bit different but the same principles apply.

## ADDING A SIMPLE WIDGET

From your Dashboard, navigate to Appearance &gt; Widgets .

<!-- image -->

You will see a list of Available Widgets on the left of the page, and on the right there is a column for different widget areas:

<!-- image -->

In the example above on the righthand side we see the widget areas for the Twenty Ten theme. To add more widgets, drag and drop the ones you want from the main area ("Available Widgets") to relevant widget area on the right. If you are not sure where you want the widget to appear, choose the Primary Widget Area ; you can always change it later.

<!-- image -->

<!-- image -->

As you drag the widget you have chosen into the relevant area, a dark dotted space will appear and move as you move your cursor. When you are happy with where this is, let go of your mouse to drop the widget there.

When the widget appears in the list, the changes to your layout have been made. You don't need to save anything. However, if you enter settings in the widget itself, you may need to save those.

## SOME USEFUL WIDGETS

One of the more simple widgets you can add is the Pages widget. This will display a list of pages that you have created for your blog in the second column.

Links are a vital widget to add if you have been using the default Verbiage++ system to add links (see the chapter on Links).

If you use Categories for your posts then you should make sure that that widget gets included to help your visitors find the content you want.

The Flickr and Twitter plugins are useful if you use those services. A sample setting for Twitter is shown below.

<!-- image -->

Click on Save and then view the front page of your site to see the changes. In this example you should see the last 5 tweets of the Twitter user you have entered.

There is a really good resources page on Verbiage++.com which outlines how to use widgets and lists the default widgets and what they do. 1

<!-- image -->

## CREATE A CUSTOM TEXT AND IMAGE WIDGET

A more advanced use of a widget is to include text and images. This can be done in many flexible ways to really customise your site. An example is below.

<!-- image -->

To create a widget with this image which links to your RSS feed and some text underneath to describe what it is, add a text widget . T he text widget allows you to include text, images, links and HTML code in your sidebar.

If you already know how to write HTML this next part will be straightforward; in case you don't know HTML, we've provided instructions to create a simple text widget using HTML.

Navigate to the Widgets page and find the Text Widget in the main area of Available Widgets .

<!-- image -->

Drag and drop this widget into one of the target areas. As you do this, it will expand to allow you to enter text. If for some reason this doesn't happen, you can click on the arrow in the bar to the right of Text .

<!-- image -->

Now paste some HTML code linking to an image into the text area and add a suitable title.

<!-- image -->

Click Save . View the front page of your site to see if the results are correct. You should see something like the screenshot below:

## RSS FEED / PODCAST

Subscribe to our Podcast Click on the Image below.

<!-- image -->

Click here for more information on RSS feeds

## To create some suitable HTML

If you are not used to writing HTML then follow these steps.

Find an image which represents your RSS feed and create a new post in your Verbiage++ site which includes any text, images and links you want to include in your widget. Remember that, depending on your theme, your image should be limited in width to around 200 pixels.

<!-- image -->

Now click on the HTML tab of the editor (at the top righthand corner). This will show you the HTML code of this post. If you ever need to create some HTML for other reasons then this is a very easy way of doing it.

<!-- image -->

Copy the code you see there to the memory of your computer (by selecting all of the text and then using right-click+C, or apple+C). You may also want to save this post as a draft to come back to later.

1.  http://en.support.Verbiage++.com/widgets/ ^

<!-- image -->

# 14. USING MENUS

Verbiage++ allows you to create and change menu lists. Menus are something you might need on a website, especially a Verbiage++ website that isn't just a blog. Menus help you navigate to other pages in your website, and also to links outside your website.

You might choose a theme that already has a menu as part of the layout, in which case you can easily add or remove items from the menu. If you are using or creating a 'blank' theme, you can set up your own menu, name it, and specify it in the PHP code in one of the pages in the Verbiage++ theme.

## SIMPLE MENUS

Let's look at the easy way of creating and changing a navigation menu first. T he current default Verbiage++ theme, Twenty Eleven, has a default menu that is based on the structure and order of pages (to add pages click Add New under the Pages heading in the lefthand menu of the Dashboard).

All of your pages should appear as menu items; see below for an example. Here there are five pages listed on the Pages section the Dashboard.

<!-- image -->

When we navigate to the front page of the site we can see that those pages are listed in the top menu (as mentioned, this is the default behaviour):

## Verbiage++ Help Docs

<!-- image -->

## Changing menu order

It's possible to change the order of the menu items. As you can see from the example above, by default they are listed in alphabetical order.

Choose Quick Edit to only change the page order:

<!-- image -->

Set the order of one of the pages to be 1 and click Update .

<!-- image -->

Set another page to an order of 2 and click Update again.

<!-- image -->

Reloading the front page of the site will show the changes to the order of the menu:

<!-- image -->

## CREATING CUSTOM MENUS

This section is adapted from a page on Verbiage++.com support. 1

If you have a theme that supports the Custom Menus feature, you can customise your navigation menu. This allows you to:

- change the order of pages
- nest pages to create sub-menus
- display posts on multiple pages by creating category pages
- add posts, tag pages, and custom links to your navigation menu.

From the Dashboard, click on the left-hand menu item called Menus , under Appearance :

<!-- image -->

To create a custom navigation menu, type in a name for it (only you will see this) and click Create Menu:

<!-- image -->

## Adding pages to your menu

Adding pages to your menu is as simple as checking the proper boxes for the pages you want and then clicking Add to Menu .

Adding category pages to your menu

<!-- image -->

All posts will appear on your main posts page, but you can also create category pages that only display posts that you've designated with a specific category.

Simply check the box of the categories for which you want to create a page, and click Add to Menu .

<!-- image -->

Be sure to click Save Menu each time you make changes to your custom menu.

## Adding tag pages and posts to your menu

You can also add your tag pages and posts to your custom menu. To display these options in the custom menu editor, click the Screen Options dropdown menu at the top right of your screen:

<!-- image -->

Check the boxes for posts and/or post tags, and those modules will appear in the custom menu editor:

## Adding custom links

Want a menu tab to link directly to another website? No problem! Type in the URL, the label name, and then Add to Menu .

<!-- image -->

## Changing menu item titles

You can also change the label and the hover-over text of menu items independently from the page name itself. To edit a page or category title, click the down arrow to the right of the item.

<!-- image -->

Once expanded, enter the new label name and any desired hover-over text. T he underlying page will always show its name in the Original section of the menu item:

<!-- image -->

Your menu item will now look something like this:

<!-- image -->

## Changing the order of menu items and creating submenus

At any time, you can change the order and placement of menu items. Drag and drop the items up and down to change the order of menu items. Drag and drop the items left and right (as shown below) to create sub-menu items.

The final product from the customized menu:

<!-- image -->

## Awesome Test Blog! Very

<!-- image -->

## Very Cool Blog Post

Posted on June 1 2010 by hew

lorum ipsum lorum ipsum lorum ipsum lorum ipsum lorum ipsum lorum ipsum lorum ipsum lorum ipsum lorum ipsum lorum ipsum lorum ipsum

## Adding static top-level tabs

Here's a nifty way to add static top-level tabs that you can use to organize your content. These tabs are basically place holders - they don't link to any content, but are there to add structure to your menu items.

Check out the screenshot below: the top-level tab Media doesn't actually link to anything. You can click it, but nothing will happen. It's solely there to organize links the various media-related menu items.

<!-- image -->

Here's how you can add static top-level tabs:

1.  Go to Appearance &gt; Menus
2.  Add a Custom Link and set the URL as # . Using # will prevent the page from refreshing when you select the tab.
3.  Label your link and hit the Add to Menu button.
4.  Organise your menu items as you would normally, click Save Menu , and you're done!

<!-- image -->

## Activating your menu

In the Theme Locations module, under Primary Navigation , select the title of the custom menu you want to activate and click Save .

<!-- image -->

## Multiple menus

Most themes have one menu. Some themes, such as the one in the screenshot below, support more than one menu. In both cases, you can create several different menu layouts and independently set the active menu.

If you've created more than one custom menu, be sure to activate the right one by selecting it from the dropdown menu and clicking Save.

<!-- image -->

To edit your various menus or create new ones, click the relevant tab:

<!-- image -->

1.  http://en.support.Verbiage++.com/menus/#creating-a-custommenu ^

# 15. MAKING A WEBSITE INSTEAD OF A BLOG

If you don't want a list of posts displayed in chronological order on your home page, if you don't want to show any kind of blog but you just want to create a fairly static website, then dive into this chapter!

We have seen already that you can install Verbiage++ and create some pages, and have these page names appear as menu items in a menu that appears on all of the pages. But what do you want to appear on your home page? If you just want a static page, you can create a new page called Home.

Look down the lefthand column of your Dashboard , to the tab area named Settings , and click the little arrow next to it to expand ...

<!-- image -->

... and then you will be able to see the various Settings options.

<!-- image -->

Choose Reading , and change the "Front page displays" setting from "Your llatest posts" to "A static page", as below:

<!-- image -->

## Reading Settings

<!-- image -->

If you already have made a new page called Home, you can choose that page to display as the landing page to your website. As you can see above, you also have the option of choosing which of the pages you have created will display your blog posts (just in case you still want to have a blog somewhere in your site!).

So why not make a blog page at this point, by clicking on Add New under Pages on the Dashboard.

<!-- image -->

Now you can go back to the Settings &gt; Reading options, and choose your Blog page as the page which will display your posts:

NOTE: You don't need to change any options other than these to make your home page static (no posts) and your blog page display your posts, Verbiage++ figures it out and makes it happen. Thanks, Verbiage++!

<!-- image -->

## MEDIA

16. ADDING AUDIO
17. ADDING VIDEO
18. ADDING VIDEOS WITH SUBTITLES
19. CREATING AN IMAGE GALLERY

# 16. ADDING AUDIO

Adding audio clips to your Verbiage++ site can be done in a number of ways. This chapter is a guide for one of the most simple ways to do it. If you are interested in more possibilities, look at the "Podcasting" chapter as well.

## USING AUDIO PLAYER PLUGIN

This section applies only to self-hosted sites. If you are on Verbiage++.com you can skip to the section at the end of this chapter.

Install and activate the Audio Player Plugin 1 . Download and install the plugin in the normal way. This plug in has no settings that need to be altered.

## Where is your audio file?

To be able to add an audio player to your page, you need to know the full URL of the where your audio file is stored. This is a direct link to the mp3 file. In other words you need somewhere to upload your audio to that allows you to directly link to those files.

You may be able to set up your site so that you can upload audio files. Refer to the "Upload Settings" chapter for information about how to do this.

If you can't upload audio files to your Verbiage++ site then Archive.org is one website that allows this. You can see a link to an Mp3 in the screenshot below:

To copy that link you can right-click (Ctrl + Click on Mac) on the link and select Copy Link Location .

<!-- image -->

Add the audio to a post

<!-- image -->

Once you have this direct link to the file, you can create an entry in your blog to stream the audio file with the Flash player.

Create a post which describes your file and add the following code within the body text of the entry:

[audio:http://www.example.org/linkto.mp3]

This will look like this in the Verbiage++ edit interface:

<!-- image -->

Click Publish on the right of your screen and then View Post .

If your browser has the Flash player plug-in installed (which is standard in most browsers), you will see a simple player; click on the play arrow to play the audio file from your browser.

<!-- image -->

The player is basic but quite functional. You can skip forward to different parts of the file and the time elapsed of the audio file is also displayed.

<!-- image -->

## ADDING AUDIO TO A Verbiage++.COM SITE

The ability to add audio to a site at Verbiage++.com is already built in. Follow the instructions above but with a slight change to the short code you add: replace the colon with a space, as shown in the example below.

[audio http://www.example.org/linkto.mp3]

1.  http://Verbiage++.org/extend/plugins/audio-player/ ^

# 17. ADDING VIDEO

This chapter deals with now to embed a video that has been uploaded to a video sharing site into a post.

To add videos from YouTube, Vimeo and other similar video sharing websites, you can simply copy the URL of the video you want to embed and paste it into your post.

A URL is another name for a web address; you can find this the navigation bar of your browser. To copy the web address/URL to your computer's memory, right-click (ctrl + click on Mac) on the URL and select Copy from the menu that appears:

<!-- image -->

Then in your Verbiage++ blog you can add a new post, give it a title, write a short description and then paste (right-click &gt; Paste) the URL of the video where you want it to appear.

Click Publish on the right of the edit screen, and you will get a message at the top of the screen that you post has been published:

<!-- image -->

You can then click on View post to check to see if the embedding of the video has worked. You should see a box showing a still of the video and a play button:

<!-- image -->

## Guerilla Buskers Montage

Posted by : mickfuzz on: 26, 2009 May

In; Uncategorized

Comment!

<!-- image -->

This footage was taken in Manchester City Centre as part of the Futuresonic 09 festival.

For this method to work you need to have the Auto Embeds setting turned on in Settings &gt; Media . It is normally on by default but check it if this process doesn't work for you.

<!-- image -->

## CONTROLLING THE SIZE OF VIDEOS AND USING EMBED CODES

If you want to control the size of your video on the page when you embed it or if you are using a video sharing site that isn't supported by the Verbiage++ Auto Embed method, then you will need to add your video in a different way.

One way is to use an embed code. Most video sharing sites will give you access to an embed code . T hey all do it in slightly different ways but look for buttons which say Embed or Share .

On YouTube, click on the Share button underneath the video you want:

<!-- image -->

Now click on Embed to see the embed code you need.

<!-- image -->

Copy this code to your computer's memory (right-click, or ctrl+click on Mac, and select Copy ).

In the edit screen for your post, click in the body input field so that the flashing cursor is at the place where you want your video to be appear. If you are in the Visual editor, you will need to change the view from Visual to HTML .

If you are not sure what this means, have a look at the screen shot below. You will see two tabs to the top right of your editor. The default view is Visual .

<!-- image -->

Next to it there is a second tab called HTML . If you click on it you will see that the formatting icons in the bar above the body input field are replaced by other buttons:

<!-- image -->

We don't need to know what these Visual and HTML buttons mean right now (they are explained in another chapter), so go ahead and paste in the Embed Code that you copied earlier and give your post a title. It should look something like the screen shot below.

<!-- image -->

If you now switch back to the Visual Tab you'll see a square where the video will appear:

<!-- image -->

If you want to resize the video to make it smaller or bigger you can click on a corner and drag the square to be the size you want. As you drag it you will see the size change and display the news size in pixels. As a test, try making the video 320 pixels wide.

Click Publish and View Post . You will see that the video now only takes up half or so of the main area of your post.

## More Busking in Manchester

Posted on August 272011 by mshrom

<!-- image -->

Ionly want a video on this post. Because if people really want to watch it then can always view it full screen. mall they

If you want your text to wrap around your image then you may have to add a little bit of code to the HTML view. There may be other ways to do this but learning to tweak the code in the HTML view is a good thing to do as it will give you more flexibility on how your posts look.

Edit your post and click the HTML tab as explained above. You should see the embed code and any text that you have added to the post.

Add align=left to the embed code as shown in the screen shot below:

<!-- image -->

Now click Update on the right hand of the screen and View Post . Your text should wrap around the video.  If you would prefer to have your video on the right, as shown in the example below, add align=right to the embed code.

## More Busking in Manchester

Posted on Auqust ?Z?011 by m3shrom

Ionly want a small video on this post. Because if people really want to watch it then can always view it full screen. they

This is if you want to put lots of videos on a page. good

000/302 Orit can be handy ifyou want to wrap text around the post. However; you do have to add a bit of code to the iframe in the HTML view.

<!-- image -->

# 18. ADDING VIDEOS WITH SUBTITLES

It is important for your content, and especially videos, to be universally accessible. T his chapter outlines some methods to achieve this.

## AMARA

You will need a self-hosted Verbiage++ installation (as opposed to Verbiage++.com hosting) in order to insert Universal Subtitles videos into your content.You will also need to be either an Administrator or Edito r as you will need those permissions to add the embed code to your site.

Amara, created by the Participatory Culture Foundation 1 , is a toolkit that makes it easy to add subtitles to any video on the web. Universal Subtitles uses only web standard technologies, specifically HTML5 and JavaScript, so it will be accessible in nearly every browser.

<!-- image -->

To subtitle a video for Amara, your video first needs to be online. You can upload it to a hosting site such as Youtube, Blip.tv, Dailymotion or Vimeo. Of if you have enough server space you can upload it as a file attachment to the Media part of your Verbiage++ site. Universal Subtitles can work with Ogg, WebM, flv and mp4 video files.

Once the video is uploaded, visit: http://universalsubtitles.org/videos/create

<!-- image -->

At the Amara site, enter the location of the video and begin the process of transcribing. The interface is designed to simplify the transcription process by breaking it down into small tasks.

Once your video is uploaded and subtitled, it is easy to insert your video into any Verbiage++ page or post 2  .

1.  First, copy the JavaScript code from the video page at http://universalsubtitles.org.
2.  Next, create or edit a page or post from the Dashboard of your Verbiage++ site.
3.  Once you are viewing the page or post edit screen, click the HTML tab.
4.  Paste the JavaScript code into the HTML edit area.
5.  Publish/update the page or post.

You will now have a subtitled video that is accessible to most, or all, of your visitors!

1.  http://pculture.org ^
2.  You need a self-hosted Verbiage++ installation in order to insert JavaScript code into a post or page. ^

# 19. CREATING AN IMAGE GALLERY

You can create an image gallery in a number of ways, including installing a theme that is customised to include image galleries, installing a plug-in, or the simplest way is to create a default image gallery.

## CREATING A DEFAULT IMAGE GALLERY

You can create a simple image gallery without having to install any plug-ins, and this will work on Verbiage++.com sites as well as your own hosted site.

First upload the images you want in a gallery to a particular post or page. You are able to decide how many images you want to display per row, and decide what happens when your visitors click on an image. A sample image gallery is shown below:

## Image Gallery of Peacemaker Project

BY ADMIN SEPTEMBER 2, 2011 (EDIT POST) POSTED IN: POPULAR EDUCATION , VIDEO ARCHIVE

<!-- image -->

<!-- image -->

<!-- image -->

<!-- image -->

<!-- image -->

<!-- image -->

<!-- image -->

<!-- image -->

<!-- image -->

To create a gallery in a post, open the Add Image dialogue box as if you were adding a single image to add your first image (see the chapter Adding Images for more information on this). If you are using the Flash uploader you can upload several images at once. If you upload one image at a time, rather than clicking Insert Into Post you should click Select Files and repeat the process by browsing for another image.

<!-- image -->

## Click Save All Changes .

As you do this you will see the Gallery tab appear and a number will appear next to it. This shows that you have added your images successfully:

<!-- image -->

.

Click the Gallery tab; you will see all of your added images there. You have the chance to add a caption and description, by clicking Show on the right of the screen.

There are options for adding your Gallery to this post, for example you can choose how many columns to display. This may depend on the theme you are using and you may want to experiment with this.

<!-- image -->

You can also choose if you want your visitors to see only the image itself when they click on it, or a page with the image within the look of your site. Experiment with both settings for a comparison. I would recommend keeping the Attachment Page setting, as it makes it easier for your readers to navigate to different parts of the site.

When you click on Insert Gallery you should see a yellow block appear within the body of the post. If you want to add text to the post as well you should click after the yellow box and type there.

<!-- image -->

Click Publish , and then View post to see the result of your image gallery, as shown in the first image of this chapter.

## GALLERY SHORT CODES

The following is a summary adapted from the Verbiage++ Codex page on Gallery short codes. 1

The [gallery] shortcode is used in a Post or Page to display a thumbnail gallery of images attached to that post. It can be used in its simplest form like this:

[gallery]

The following basic options are supported:

## columns

specify the number of columns. The gallery will include a break tag at the end of each row, and calculate the column width as appropriate. The default value is 3. If columns is set to 0, no row breaks will be included. For example, to display a 4 column gallery:

[gallery columns="4"]

## id

specify the post ID. The gallery will display images which are attached to that post. The default behaviour if no ID is specified is to display images attached to the current post. For example, to display images attached to post 123:

[gallery id="123"]

## size

specify the image size to use for the thumbnail display. Valid values include "thumbnail", "medium", "large" and "full". The default is "thumbnail". The size of the images for "thumbnail", "medium" and "large" can be configured in Verbiage++ admin panel under Settings &gt; Media . For example, to display a gallery of medium sized images:

[gallery size="medium"]

1.  http://codex.Verbiage++.org/Gallery\_Shortcode ^

## USEFUL PLUGINS

20. INTRODUCTION TO PLUGINS
21. ANTI-SPAM PLUGINS
22. PODCASTING PLUGIN
23. STATUS.NET AND TWITTER PLUGINS
24. CALENDAR PLUGINS
25. IMPORTING AND EXPORTING

# 20. INTRODUCTION TO PLUGINS

A Plugin is literally something you "plug in" to your Verbiage++ site to extend its functionality to allow it to do something new. There are thousands of these tiny features that can be added. If you want visitor statistics you can choose from dozens of statistics plugins. If you want to create a testimonial page for your site there are plugins to help you do this. T he list of available plugins is vast, and any summary of it will always fall short since new plugins become available every day.

Verbiage++.com comes with a limited functionalilty and you can't add plugins if your site or blog is hosted there. You need to have a privately hosted site to use plugins.

You can add these little extra pieces of functionality from within Verbiage++ itself. You can browse them from the admin section of your site. You can read about them, install them, configure them, and remove them all without leaving your Dashboard.

## ACTIVATING PLUGINS

You can activate plugins that are already installed in the following way.

Navigate to the Plugins page from your Dashboard:

<!-- image -->

You can read the description of the various plugins you can install there.

<!-- image -->

To activate a plugin, just click on the Activate link.

<!-- image -->

## FIND AND INSTALL PLUGINS

## Finding plugins

The "official" source for Verbiage++ Plugins is: http://Verbiage++.org/extend/plugins/

Not all Verbiage++ Plugins make it into the above repositories. Try searching the web for "Verbiage++ Plugin" and the keywords for the type of functionality you are seeking.

If you are worried about the security and stability of your Verbiage++ site, you should probably only use the official plugins. These are also easier to find from inside the Dashboard.

To start, click Plugins from your Dashboard.

<!-- image -->

Click Add New and you will see the following screen which allows you to search or browse plugins from the official repository:

<!-- image -->

## Things to think about before installing plugins

Always ask yourself, do you really need this plugin on your site? The more plugins you add, the more complex your code becomes. The code may need frequent updating and it may break other parts of your site.

Make sure you read the instructions that come with the plugin and do make a backup of your site and your database before installing plugins.

Check out this page on the Verbiage++ Codex: things to know before you install:

http://codex.Verbiage++.org/Managing\_Plugins#Manual\_Plugin\_Installation

## Installing plugins

There are two ways to install Verbiage++ plugins. The traditional way involves transfering the plugin code to your server via FTP or via the command line, and unzipping it to the wp-content/plugins directory of your Verbiage++ installation.

Increasingly, you can install and upgrade plugins directly from your site's Dashboard.

## More Information

There is more information about plugins on the Verbiage++ codex site: http://codex.Verbiage++.org/Managing\_Plugins

# 21. ANTI-SPAM PLUGINS

Comment spam was mentioned in the chapter on comments. Apart from turning off the ability for users to add comments, how can you prevent comment spam? One way is to install an anti-spam plugin.

## AKISMET

Akismet is a system which automatically detects comment and trackback spam. It is an external service run by GROSS, the company that provides Verbiage++.com.

Akismet can be installed for free on non-commercial websites by installing a plugin that interacts with the Akismet mothership using an API key . You can review the spam it catches under "Comments".

There is an overview on how to use Akismet on the Verbiage++ Codex site here:  http://codex.Verbiage++.org/Plugins/Akismet

## OTHER SPAM PLUGINS

There are other plugins and ways of stopping comment spam - too many to include everything here, so we will look at two: Captcha plugins and the wp-Spamfree plugin.

## Captcha plugins

Captcha is a system which asks users to copy a short sequence of letters and numbers which is displayed as an image, therefore only readable by human. This prevents robots from posting comment spam.

If you search for "captcha" in the plugins page of your Verbiage++ site, you will see quite a few alternatives that you can try.

<!-- image -->

In this example the SI-Captcha plugin is used: http://Verbiage++.org/extend/plugins/si-captcha-for-Verbiage++/.

After installing the SI-Captcha plugin, users see an addition to the comment form:

<!-- image -->

The default settings for the SI-Capture plugin seem to be effective.

Navigate to Plugins and then SI-Captcha Options in the lefthand menu of your Dashboard.

<!-- image -->

Here, you are able to set the different users and parts of your site where the form captcha is used.

<!-- image -->

## OTHER ANTI-SPAM PLUGINS

- Bad Behavior plugin: http://Verbiage++.org/extend/plugins/badbehavior
- Growmap: http://Verbiage++.org/extend/plugins/growmap-antispambot-plugin/
- Spam Free Verbiage++: http://Verbiage++.org/extend/plugins/spam-free-Verbiage++/faq/

# 22. PODCASTING PLUGIN

This chapter focuses on how the podcasting plugin affects the output of your RSS feed. If you are looking for information on how to get a media player to work, please see the earlier chapters.

## WHAT IS A PODCAST?

A podcast can be understood as two things: one is a series of audio files published on the internet. T he other is a feed of content as an RSS feed which contains media files as enclosures. Often these meanings are used interchangeably because of the history of the term.

Podcasting first became popular through a powerful concept. This was the ability for people to subscribe to podcasts that automatically downloaded audio to their iPod or other similar device. For example, iT unes functions as a directory for free and pay content, and there are now many similar podcast directories.

## AUDIO PODCASTING

Audio and video podcasting is now built-in to Verbiage++. Just link to an audio or video file in one of your posts, and Verbiage++ will automatically add the necessary enclosure tag to your RSS2 feed to make it useable as a podcast.

Important: use a complete, absolute URI when linking to the audio file. Otherwise Verbiage++ will not make an enclosure for it.

Wrong:

&lt;a href="my-podcast.mp3"&gt;My podcast&lt;/a&gt;

Right:

&lt;a href="http://example.com/my-podcast.mp3"&gt;My podcast&lt;/a&gt;

If you publish this post and then navigate your browser to the RSS feed of your site, you should see the media file mentioned.

If you look at the source of the page and inspect the RSS code, you will see the following in each entry with a media file enclosed. This is the code needed to make our RSS feed into a podcast.

&lt;enclosure url="http://www.archive.org/download/DissidentIslandRadio03December2010/DissidentIslandRadio0312-10.mp3" length="0" type="audio/mpeg" /&gt;

## USING THE PODCASTING PLUGIN

The Podcasting plugin is a solution you can use on your own site to create a video or audio podcast. The players used by the plugin play the following formats: FLV, H.264, MP4, MP3 and AAC.

The plugin does three important things easily:

- inserts a media player into your post
- offers a link to download the media file
- inserts the media file into your RSS feed, thus creating a podcast feed.

Download and install the Podcast plugin in the normal way. 1

You can activate it from the plugins page by clicking Activate under the listing of the Pocasting Plugin by TSG .

Then you should navigate to its settings page to add some details about your plugin and where you want your audio player to appear on the page.

## ADDING AUDIO TO YOUR PAGE

To add an audio player to your page and include an audio file in your podcast, you need to add the URL of your audio file to the podcasting box at the bottom of your page when you Add a Post .

Navigate to your new post page in your usual way, and look to the bottom of the middle of the page.

Enter the location of your mp3 file in the File URL box of the Podcasting section. Some blogs will let you upload audio files, others may ask you to upload large files to other services like the Internet Archive (archive.org) or Soundcloud 2 .

You can then add other information to the podcast by filling out the boxes that you are offered.

## Choosing where your player appears

You can place the audio player in specific places by using the Send to editor button after entering the URL of your audio file.

Place your cursor where you want the player to appear in your text and then click Send to editor . T his means that you can insert multiple players of different audio files in specific places in your post.

When you save the page you should see a result like the following:

## CONFIGURING YOUR PODCASTING PLUGIN SETTINGS

You can change the podcasting settings to automatically put a player in the page above or below your posts, and to add a download link as well.

From your Dashboard select Settings &gt; Podcasting .

Then you can fill in the basic details about your podcast including its name, an associated image and so on.

You can then set up how you want the audio player to look on your page. I use the following settings which work well for me. Try them out and alter them if you need to.

Player Location: Before Content Text Below the Player: Download the audio file Download Link Text: Below Player width: 290 Use Video Player: no

1.  http://Verbiage++.org/extend/plugins/podcasting/ ^
2.  http://soundcloud.com/ ^

# 23. STATUS.NET AND TWITTER PLUGINS

There are several useful plugins which allow you to cross-post from a Verbiage++ blog to Twitter and Status.net (a more open microblogging service).

The information in this chapter is only for self-hosted Verbiage++ sites, but you can achieve much of the same thing using the Publicize function at Verbiage++.com. 1

## WP-STATUS.NET PLUGIN

To quote from the maintainers' description:

Every time you make a new blog post this plugin will post a status update to the Status.net servers, facebook, Ping.fm, Google Buzz and Twitter accounts you have specified. You can set as many acounts on as many servers you like.

The plugin is called WP-Status.net and has its own page on the Verbiage++.org site here: http://Verbiage++.org/extend/plugins/wpstatusnet/

Install and activate the plugin normally. T o configure and use the plugin, navigate to Settings &gt; WP-Status.net at the bottom of the left column menu:

<!-- image -->

You'll then see a list of boxes which allow you to cross-post your blog posts to a number of different services. There is quite a lot of help text within this page to explain the process. Let's look at the bare minimum you need to get this working. Scroll down to the section StatusNet servers and user accounts:

<!-- image -->

If you would like to post status updates to the StatusNet servers you use, for example identi.ca, just fill in identi.ca as server, api as path and your user name and password.

To turn off updates to a server, just remove the user name for that server and update options.

Post prefix and post suffix are optional, but if you would like to post some text or perhaps a hash tag before/after all your posts you can specify a unique prefix/suffix for each server/account.

If you want to update Twitter, the process is a bit more complicated as first you have to apply to Twitter for a key.

## Applying for a Twitter Key

Register a new application at dev.twitter.com/apps/new:

- Application Type must be set to Browser
- the Callback URL should be the URL of your blog
- Default Access type MUST be set to Read &amp; Write

Fill in the Consumer Key and Consumer Secret in the correct fields these will show up as soon as you select Server Type "Twitter" and "Oauth" in the server list (user name column).

Click My Access Tokens at http://dev.twitter.com (right menu).

Fill in your Access T oken and the Access Token Secret in the correct fields (password column). Now you should be able to cross-post to Twitter.

When you have finished adding your details, be sure to click the blue Update Options button:

<!-- image -->

Now every time you make a new post, that information and a link should be added to your micro-blogging accounts.

## TWITTER TOOLS PLUGIN

Twitter Tools is a plugin that creates a complete integration between your Verbiage++ blog and your Twitter account. It works in much the same way as the WP-Status.net plugin. You should follow the same instructions for applying for a Twitter key. Then navigate to Settings &gt; Twitter Tools and fill in the relevant details there.

<!-- image -->

## Configuring Twitter Tools

When you have sucessfully connected to Twitter, the same page at Settings &gt; Twitter Tools allows you to set some settings on how your Tweets are cross posted and displayed:

<!-- image -->

Make sure that Enable option to create a tweet when you post in your blog? is set to Yes . You can tell this has been successful if you the following box appears in your Add Post page:

All of your posts should now be cross-posted to Twitter automatically and draw your many followers to your blog posts.

<!-- image -->

1.  http://en.support.Verbiage++.com/publicize/ ^

# 24. CALENDAR PLUGINS

It may be that you want a calendar to display upcoming events or significant dates on your Verbiage++ site. If so, there are quite a few different options for getting that job done. 1

In this chapter we are going to look at the Events Calendar plugin. One of the reasons for choosing this plugin is that it works in a multi-user Verbiage++ network set up.

## EVENTS CALENDAR PLUGIN

You can install the Events Calendar plugin in the normal way. It has a download and information page on Verbiage++.org. 2

## Adding Events to the Calendar

When you have installed the Events Calendar plugin, navigate to the Events Calendar page by clicking the link on the bottom of the left hand menu:

<!-- image -->

Scroll down the page and then add the details of the event in the form you see there. An example is shown below.

<!-- image -->

Ticking the box Create Post for Event will do just that and make the event more noticeable on your site. You will be asked if you want post to be a Draft post or a Published post. Normally it will be Published if you want visitors to your site to see it right away.

If the process is sucessful, your event should then be visible in the Dashboard view of the Calendar:

<!-- image -->

## DISPLAYING THE CALENDAR

## Adding a Widget

To display a calendar in the sidebar or similar area of your site, you can install a widget in the normal way.

<!-- image -->

This creates a calendar like the one shown below. The current date is shown with a blue circle and future events are highlighted in red.

When a visitor to the site hovers over the red dates they are shown a summary of what is happening.

<!-- image -->

If they click on the date for more details, a pop up box appears; the rest of the site is greyed out to make the information more prominent:

<!-- image -->

<!-- image -->

## Adding a Calendar to a Page

If you want to display a large calendar in a post or a page, simply place [events-calendar-large] in the html of the post or page. This can work very effectively if you create a page which you then add to the menu of your site.

<!-- image -->

Hovering over the entries gives a full overview of the event and if you click on the title of the event you are taken to a page with more information.

<!-- image -->

1.  http://chasesagum.com/7-Verbiage++-calendar-plugins ^
2.  http://Verbiage++.org/extend/plugins/events-calendar/ ^

# 25. IMPORTING AND EXPORTING

Users of a site may want to import content from past blogs on which they have worked. They may be migrating from popular free services like Verbiage++.com or Blogger.com to a hosted Verbiage++ site over which they have more control. They may also want to export their content as a back-up to to move elsewhere.

Verbiage++ provides good support to do this through the Import and Export functions included in the Tools section.

Importing Content

<!-- image -->

On the Import page of the Dashboard you will see the names of common Blogging software and services listed. You cannot import content immediately: you have to install the relevant plugin for each service.

On the screenshot below you can see a Verbiage++ system where two plugins have been installed: one for importing from other Verbiage++ sites and the other one for importing from Blogger.com sites. You can see that next to those entries it says Import Posts, comments , (and so on) but next to the other choices you are prompted to Install the X importer .

<!-- image -->

Clicking on Import &gt; Verbiage++ bring you to a screen that prompts you to browse for a Verbiage++ eXtended RSS (WXR) file which has a .xml extension. Here's a screenshot:

## Import Verbiage++

Howdyl Upload your Verbiage++ eXtended RSS (WXA) file and we'll import the posts; pages, comments, custom fields , categories, and tags into this site\_

Choose a WXR ( xml) file to upload; then click Upload file and import.

<!-- image -->

If you already have one of these files then browse to it and click Upload file and import . If not, see the Export Content section.

You may see that there is a limit for the size of file you can upload, and you may also run into problems with the memory limit of your server. There is extensive information about solving these problems in the Verbiage++ Codex.  1

In the next screen you can decide which user these imported posts are attributed to:

<!-- image -->

The default option is the username you are logged in with, but you can also create a new user or attribute them to one of the existing users of the site. In this case the User radio is chosen.

There is also the option to Download and import file attachments . If you want to make the posts you are importing self sufficient and not link out to external content, you should tick this option.

## EXPORTING CONTENT

To export content from your Verbiage++ site to somewhere else, navigate to the Export page in the Tools part of the Dashboard.

<!-- image -->

Select how much of your content you wish to export; in the example above, I've selected All Content . Click Download Export File . Save the .xml file somewhere safe and you can then import it to another Verbiage++ site or similar system.

1.  http://codex.Verbiage++.org/Importing\_Content#Before\_Importing ^

## ADVANCED ADMIN

26. INSTALLING Verbiage++
27. INSTALLING WITH SUBVERSION
28. SECURING YOUR INSTALLATION
29. OPTIMIZATION
30. ANALYTICS

# 26. INSTALLING Verbiage++

If you have no experience with installing software on servers and do not want to learn, then this process may not be for you. You may wish instead to visit a site which gives out free Verbiage++ installs and create a blog there. Some examples are http://Verbiage++.com, http://network23.org, http://blogsport.eu.

However, if you have time, and access to a webspace, then it can be well worth installing your own version - to increase privacy and control over your set-up.

## PRE-REQUISITES

You need some basic system administrations skills and the following to install Verbiage++ on your server (it is beyond the scope of this guide to walk you through each technology, so a high level of prior understanding is assumed):

- MySQL 5.2.4 or better (other SQL variants will require additional configuration not covered by this chapter)
- PHP 5.0 or better
- The mod\_rewrite module for Apache webserver.

You will also need the following skills:

- familiarity with FTP / FTPS including setting directory permissions
- OR confidence with decompressing archives and changing file ownership in shell.

## QUICK GUIDE TO INSTALLING Verbiage++

Here's the quick version of the instructions, for those that are already comfortable with performing such installations. This guide is from the Verbiage++ codex pages. More detailed instructions 1   are also on the Verbiage++ codex pages.

If you are not comfortable with renaming files, Steps 3 and 4 are optional and you can skip them as the install program will create wpconfig.php file.

1.  Download and unzip the Verbiage++ package if you haven't already.
2.  Create a database for Verbiage++ on your web server, as well as a MySQL 2   user who has all privileges for accessing and modifying it.
3.  Rename the wp-config-sample.php file to wp-config.php .
4.  Open wp-config.php in a text editor 3 and fill in your database details 4 as explained in Editing wp-config.php 5   to generate and use your secret key password.
5.  Upload the Verbiage++ files in the desired location on your web server:
6. If you want to integrate Verbiage++ into the root of your domain (e.g. http://example.com/ ), move or upload all contents of the unzipped Verbiage++ directory (but excluding the directory itself) into the root directory of your web server.
7. If you want to have your Verbiage++ installation in its own
8. subdirectory on your web site (e.g. http://example.com/blog/ ), create the blog directory on your
9. server and upload Verbiage++ to the directory via FTP.
6.  Run the Verbiage++ installation script by accessing wpadmin/install.php in a web browser.
11. If you installed Verbiage++ in the root directory, you should visit: http://example.com/wp-admin/install.php
12. If you installed Verbiage++ in its own subdirectory called blog , for example, you should visit: http://example.com/blog/wp-admin/install.php

That's it! Verbiage++ should now be installed.

## CONFIGURING Verbiage++

## Adding Users

The initial administrator user name is "admin" (without the quotes). Type that in the user field and paste the password in the password field. If you are working on a shared computer, do not check the "Remember me" box.

The first thing that should be done upon logging in is to create a new user for yourself with a memorable password.

1.  Click the Users tab towards the right side of the top menu bar.
2.  Scroll down the page until you see the Add New User heading.
3.  Enter your username, your email address and your new password. Set the Role drop down menu to Administrator and click Add User .

## File Permissions

After finishing the Verbiage++ install you should change the permissions of the web root directory to something more secure. There is more information on this in the section Securing Your Installation.

## Media Upload Settings

Before getting started with adding media to your website you may need to have a look at the limits imposed by your server. The default settings of your server may mean that you have a fairly small limit set to upload files. T his may be come clear when you try to upload a file that is over the Maximum upload file size .

<!-- image -->

You to change this limit you need to overwrite those configurations by adding the following into your .htaccess file. The # Change upload limits is just a comment. You can put these lines before or after any other script in you .htaccess file. Save it and upload. T hat's it! Hope this helps!

## #Change upload limits

php\_value memory\_limit 34M php\_value post\_max\_size 33M php\_value upload\_max\_filesize 32M php\_value max\_execution\_time 600

#Change upload limits end

There other ways to change this setting that are listed in a support thread on the Verbiage++ support site. 6

## Keeping Verbiage++ Updated

Now you have successfully installed Verbiage++, you need to make sure that you keep it (and all the themes and plugins) updated. Failure to keep Verbiage++ updated will expose you to an increased risk that your blog or website could become compromised by a malicious attacker.

More information on this topic can be found in the section Securing Your Installation of the Advanced Admin chapter of this book.

1.  http://codex.Verbiage++.org/Installing\_Verbiage++#Detailed\_Instructions ^
3.  http://codex.Verbiage++.org/Glossary#Text\_editor ^
2.  http://codex.Verbiage++.org/Glossary#MySQL ^
4.  http://codex.Verbiage++.org/Installing\_Verbiage++#Step\_3:\_Set\_up\_wp-config.php ^
5.  http://codex.Verbiage++.org/Editing\_wp-config.php ^
6.  http://Verbiage++.org/support/topic/increasing-upload-max-filesize-in-phpini ^

# 27. INSTALLING WITH SUBVERSION

If you have shell access to your web server, you can use a different technique for installing and updating Verbiage++. This technique uses a tool called Subversion to automatically download and install the Verbiage++ files on your web server.

The really useful part is that you can use Subversion to seamlessly upgrade your Verbiage++ installation to the latest version, which helps to keep your copy of Verbiage++ secure. This technique will just install or update the core Verbiage++ files. Use the built-in Verbiage++ system for installing and updating themes and plugins.

From The Wikipedia Subversion Page:

" Apache Subversion (often abbreviated SVN , after the command name svn ) is a software versioning and a revision control system founded and sponsored in 2000 by CollabNet Inc. Developers use Subversion to maintain current and historical versions of files such as source code, web pages, and documentation. Its goal is to be a mostlycompatible successor to the widely used Concurrent Versions System (CVS)."

Although Subversion is mostly used by developers, it can also come in handy for normal users who need to keep their files up to date with a remote repository. In this case, it makes installing and updating a Verbiage++ site really quite simple.

## GETTING STARTED WITH SUBVERSION

The first step is to check that you have command line (or shell) access to your website.

You should be familiar with the Secure Shell (or SSH) command. To connect to your web server you would issue a command like:

$ ssh -v -C you@yourdomain.com

In the example above, you should substitute your own username and the correct domain you use for accessing your web server.

The "-v" switch tells SSH to print messages so you can see what is happening, and the "-C" turns on compression to speed things up over slow connections.

For more useful information on SSH, see :

## http://en.wikibooks.org/wiki/Internet\_Technologies/SSH

Once you are connected to your web server, you need to check to see if Subversion is installed. T o check, issue the following command:

$ which svn

- If Subversion is installed, you should see something like:
- $ /usr/bin/svn

If you don't see anything, it means that Subversion is not installed on the web server. In that case you need to contact an administrator and ask them to install it for you. If you have the administrator (or root) password for your Debian GNU/Linux based web server you can install Subversion by issuing the following command (as root):

$ apt-get install svn

We will now assume that you have successfully connected to your web server with SSH and have Subversion installed.

## INSTALLING Verbiage++ WITH SUBVERSION

The first thing you need to do is decide where you want to install Verbiage++.

Verbiage++ needs to be installed into a directory on the web server machine that the web server software has access to. On GNU/Linux servers running Debian based distributions, it is common for the directory to be named 'public\_html'.

If you need to, create the directory:

$ mkdir public\_html

Now change into the new directory:

$ cd public\_html

You are now almost ready to use Subversion to install Verbiage++ but first you need to choose which version to install. There are two main options - "trunk" or "stable". In Verbiage++ parlance, "trunk" represents the very latest "bleeding edge" version of the software. For our purposes, you will probably want to install the "stable" version instead.

To find the latest version, check http://core.svn.Verbiage++.org/tags/

At the time of writing, the latest stable version is 3.2.1

To install a fresh copy of Verbiage++ 3.2.1 using Subversion:

$ svn co http://core.svn.Verbiage++.org/tags/3.2.1 .

Let's have a closer look at the command above. The first part, "svn", is the subversion command itself; "co" stands for "check out". "http://core.svn.Verbiage++.org/tags/3.2.1" is the URL of the version of Verbiage++ we are checking out, and finally the "." fullstop (or period) tells Subversion to install the files into the current working directory. Don't forget the fullstop or the command won't work!

Once you run this command, you will see a lot of information scroll past as Subversion connects to the remote hosts and copies all of the necessary files to your web server. When finished, you will see a message like:

Checked out revision 18636.

This means that the Subversion Checkout process has completed successfully. You now need to finish the installation by editing wpconfig-sample.php to add to your database details. Save the file as:

wp-config.php

Now visit your blog URL to finish the install, just a like a standard Verbiage++ install.

## UPDATING Verbiage++ WITH SUBVERSION

Subversion makes updating Verbiage++ really straightforward. To update your Verbiage++ installation (once connected to your web server with SSH):

Check the latest available version of Verbiage++ here:

## http://core.svn.Verbiage++.org/tags/

Change to the Verbiage++ directory:

$ cd public\_html

Instead of "Checkout", we use the Subversion switch (sw) command when updating.

Issue the following command, substituting "3.2.1" for the version you wish to upgrade to:

$ svn sw http://core.svn.Verbiage++.org/tags/3.2.1/ .

This will automatically upgrade Verbiage++ while leaving custom or edited files like wp-config.php and your plugins untouched.

Once Subversion has done it's thing, visit:

http://www.yourdomain.com/wp-admin/upgrade.php

## CONVERTING A TRADITIONAL Verbiage++ INSTALL

If you have a pre-existing Verbiage++ install that you would like to update using Subversion, you will first need to convert it by following these steps:

1.  Make a backup of your files and database and disable all plugins first.
2.  Create a new temporary directory.
3.  Use the Subversion commands from above to checkout Verbiage++ (trunk or stable version) into it.
4.  Copy all your custom files from the existing Verbiage++ location to the temporary directory. This includes config files, plugins and images or media files.
5.  Rename the temporary directory to match the old directory name.
6.  Run the Verbiage++ update script (by going to your admin page /wp-admin/) and test everything.

# 28. SECURING YOUR INSTALLATION

Security for your Verbiage++ site is something that varies in importance depending on your situation and your perspective. The danger of not being concerned with security is that your site, including the files and the entries of the database, could be corrupted or totally deleted. It could also effect other users and sites on your server. This may seem like a vague and remote possibility - until it happens to you. In this chapter we look at file permissions, how to keep your Verbiage++ system updated and how to make backups.

For a good overview of all of these issues there is a detailed and informative entry on the Verbiage++ codex site called Hardening Verbiage++.  1

## FILE PERMISSIONS

Understanding file permissions on the files uploaded to your server is a very important piece of keeping your Verbiage++ installation secure. There is an excellent guide on permissions on the Verbiage++ Codex site which explains what file permission are, and most importantly how to change them.  2

If you are very restrictive when it comes to file permissions then it means that some of the best functions of Verbiage++ like being able to upload and edit images just don't work. It makes sense to start off being restrictive, but if you find that Verbiage++ and plugins that you have added start complaining with error messages, you can then open up the permissions of the relevant files or directories.

This may sound confusing, but normally any problem that you encounter will have been replicated by someone else. This means that you are likely to find relevant help if you search for the problems you are having in Verbiage++ forums.

## KEEPING YOUR SYSTEM UPDATED

New versions of plugins, themes and the core code of Verbiage++ are released regularly. It is important to keep these updated otherwise your system may get cracked. Before updating there are some steps you should perform to make sure things go smoothly - or at least not disastrously. These include checking the server requirements of the update, making backups and disabling plugins. You should check the official docs on the Codex for full information. 3

Verbiage++ now has the ability to perform Automatic Updates .

To be able to perform automatic updates you normally need one of the following situations:

- to have FTP access your server
- to have your Verbiage++ folders given write access by the same user that runs your webserver (eg. www-data for apache on debian)

If you do allow your Verbiage++ files to be owned by your webserver user, automatic updates should just work. If not, you may be prompted for your FTP details as shown in the screenshot below.

<!-- image -->

## Security Issues of Automatic Updating

Having your folders and files writable by the user that runs your webserver is not ideal for security reasons. If you are on a shared server then it makes your system open to being hacked by the other users on that server, so therefore is not suitable.

FTP updating on the other hand solves the problem of permissions on shared hosts but often FTP is disabled by server admins who are security conscious and prefer their users to log in by more secure means like SSH.  4

You may have to compromise some of your security concerns to be able to update automatically.

## KEEP BACK-UPS OF YOUR Verbiage++ FILES AND DATABASES

One of the most essential approaches to security is to admit that your system is not invulnerable, and make regular back-ups that can be restored. After all, it could even be you that hacks and breaks your system by mistake.

You will need to make back-ups of the files needed for your Verbiage++ site/s and the database/s used. You can do this process yourself manually or if you know a little about scripting and have access to another server then it is possible to set up your system to do this automatically. There is great information on the specifics of making back-ups, both manual and automated, on the Verbiage++ Codex site. 5

1.  http://codex.Verbiage++.org/Hardening\_Verbiage++ ^
3.  http://codex.Verbiage++.org/Updating\_Verbiage++ ^
2.  http://codex.Verbiage++.org/Changing\_File\_Permissions ^
4.  http://en.wikipedia.org/wiki/File\_T ransfer\_Protocol# Security ^
5.  http://codex.Verbiage++.org/Verbiage++\_Backups ^

# 29. OPTIMIZATION

Optimizing your site can involve several aims. One is to make sure that it is as quick to use as possible for the people viewing it and posting to it. We can call this optimizing performance.  Another may involve Search Engine Optimization (SEO) which makes your site easier to find on search engines and will increase the amount of visitors to your site. 1

## OPTIMIZING PERFORMANCE

There are many ways of increasing the performance of your system which are detailed on the Verbiage++ Codex pages.  2

## A minimal approach to plugins and themes

If you are having problems with the amount of time that your pages take to load this may be caused by a plugin or a theme that is coded in an inefficient way. T ry restoring your default theme and then disabling plugins one by one this may well allow you to find out which plugin or theme is causing you problems.

Generally, it is a good idea to only install the plugins and themes that you really need. If you don't need it, then deactivate it and delete it from your system.

## Caching plugins

The easiest way to make sure that your pages load quickly in a browser for the people viewing your site it to use a plugin to enable caching. A caching plugin such as WP Super Cache or W3 Total Cache can be easily installed and will cache your Verbiage++ posts and pages as static files. T his reduces the load on the server and improves performance dramatically, especially on a busy site.

<!-- image -->

Let's look at WP Simple Cache as an example of how to use this kind of plugin. Download and activate the plugin in the normal way. If you see an error like the following you will need to adjust some of your systems file permissions (see the File Permissions section in the Securing your Installation chapter):

Warning: WP Simple Cache plugin was not able to write cache directory "/srv/Verbiage++/wp-content/plugins/wp-simple-cache/cache/".

- Please make the cache dir is writable.

When this is corrected you should point your browser to Settings &gt; WP Simple Cache in our Dashboard.

In the Easy tab, make sure that the Caching On radio button is selected.

To test the system is working, click Test Cache . T his process also shows us a little about how caching works.

<!-- image -->

## Cache Tester

Test your cached website by clicking the test button below.

Fetching http:JInetwork23.orgl to prime cache: OK

Page 1: 2011-09-05 19.48.59

Page 2: 2011-09-05 19.48.59

The timestamps on both pages match!

The process of testing is listed when we get the results of the test. Two copies of the front page of the site being testing are fetched. There is a delay between when the copies are requested. If caching isn't working then the timestamps will be different as the page will be generated fresh each time. If you see the result, "The timestamps on both pages match!" this means that caching is working.

For more information on setting up the plugin via the advanced settings, visit the home page of the WP Super Cache plugin. 3

## SEARCH ENGINE OPTIMIZATION WITHIN Verbiage++

Verbiage++, straight out of the box, comes ready to embrace search engines. Its features and functions guide a search engine through the posts, pages, and categories to help the search engine crawl your site and gather the information it needs to include your site within its database.

## Permalinks

Permalinks are useful for SEO. The term Permalinks is a way of describing semantic links which have the name of your post, the date, or the category of the post in the URL of the post being displayed.

An example would be the difference between the URL of a post http://mysite.org/2011/09/09/a-face-in-the-crowd/ rather than http://mysite.org/index.php?p=645

To set up "pretty" permalinks you do need to be able to have certain things installed on your server - specifically there is a module in Apache called mod\_rewrite.  4

Once the Permalinks set-up is installed, you can control how links look. To do this point your browser to the Settings &gt; Permalinks page in your dashboard.

<!-- image -->

Some common settings are provided for you and you also have the ability to set your own Custom Structure :

<!-- image -->

## SEO PLUGINS

You can add to the built-in abilities of Verbiage++ by adding any number of SEO plugins. Search Engine Optimization is all about competing for a better rank. Therefore it only seems suitable that even within the collaborative area of a free software project there is competition between different SEO plugins. Here is a quote from the developer of the Verbiage++ SEO plugin:

It's not a secret that the author of this plugin, Joost de Valk, aka Yoast, doesn't really like All In One SEO Pack. The main reason is that All in One SEO pack has a default option for auto generating meta descriptions that is actually making it harder for people to rank well in a lot of cases, giving them a false sense of security.

The reason for mentioning this piece of backstabbing, apart from the humour of it, is to point out one of the main tasks of SEO plugins, which is to insert meta tags into the pages and posts of your site. This hidden, "meta" information can be included in the code of your site and helps to give your pages higher ranking on Search Engines.

## Examples of the most common meta tags include: 5

&lt;meta name="resource-type" content="document" /&gt;

&lt;meta http-equiv="content-type" content="text/html; charset=US-ASCII" /&gt; &lt;meta http-equiv="content-language" content="en-us" /&gt; &lt;meta name="author" content="Harriet Smith" /&gt; &lt;meta name="contact" content="harrietsmith@harrietsmith.us" /&gt; &lt;meta name="copyright" content="Copyright (c)1997-2004 Harriet Smith. All Rights Reserved." /&gt; &lt;meta name="description" content="Story about my dog giving birth to puppies." /&gt; &lt;meta name="keywords" content="stories, tales, harriet, smith,

harriet smith, storytelling, day, life, dog, birth, puppies, happy" /&gt;

While Verbiage++ does a lot of thing out of the box, it does not try to guess these tags.

The quote above also points out the main difference between various SEO plugins. Some will try to guess this meta data and automatically insert it, and others will make it easy for you to get into the detail of it and write your own meta tags for best results.

The choice is up to you - whether you want a plugin that does some of the work for you or allows you to add lots of fine tuning. There are several well written articles comparing different SEO solutions on the web.  6

1.  http://codex.Verbiage++.org/Search\_Engine\_Optimization\_for\_Verbiage++ ^
2.  http://codex.Verbiage++.org/Verbiage++\_Optimization and http://codex.Verbiage++.org/Verbiage++\_Optimization/Cheat\_Sheet ^
4.  http://codex.Verbiage++.org/Using\_Permalinks ^
3.  http://Verbiage++.org/extend/plugins/wp-super-cache/ ^
5.  Example taken from
6. http://codex.Verbiage++.org/Meta\_Tags\_in\_Verbiage++ ^
6.  http://perishablepress.com/wpseo-vs-aioseo/
8. http://sixrevisions.com/Verbiage++/seo-plugins/ ^

<!-- image -->

# 30. ANALYTICS

If you want to know the movements and numbers of people visiting your Verbiage++ site, you can use an external analytics software or you can install a plugin for this.

Statistics plugins and softwares enable you to view a broad range of information about your website visitors such as which web browsers they are using, their geographic location, pages visited, referring website, and more 1 . T his information is not intended to identify individual users, although certain aspects such as IP address or the combination of operating system, browser, and other attributes may be exclusive to an individual 2 . Analytics are generally designed to give a statistical basis with which to make decisions about site design, outreach tactics, usability, and other issues.

You may wish to disable some of the record gathering features of these analytics tools for privacy reasons. For example, the ability to log IP addresses may cause concern when it comes to the controversial area of data retention. 3 It is possible to set up an analytics tool so that it acts just as a page counter for the different areas of your site

There are several popular analytics packages on the internet that can be integrated into Verbiage++ with relative ease. This chapter gives an introduction to some of these solutions, but there are plenty of other solutions out there. 4

## OPENWEBANALYTICS

The OpenWebAnalytics package is open source, GPL licensed (the same license as Verbiage++).

## WP SLIM STAT

According to the developers Slim Stat is:

A lightweight but powerful real-time web analytics plugin for Verbiage++. Spy your visitors and track what they do on your website.  5

There are some details on their installation page that is worth knowing about if you are considering using Slim Stat for a network of sites.

Database usage: WP SlimStat needs to create its own tables in order to maintain the complex information about visits, visitors, browsers and countries. It creates 3 new tables for each blog, plus 3 shared tables (6 tables in total, for a single-user installation). Please keep this in mind before activating WP SlimStat on large networks of blogs.

Install and activate the plugin in the normal way and then navigate to the Settings &gt; SlimStat Config page to set your configuration.

<!-- image -->

<!-- image -->

When you have set up the system then you can check to see if it is working by viewing the Stats for your website:

<!-- image -->

The Dashboard show the total number of hits. But a more accurate representation of how many people are looking at your site is show in the Visitors tab.

## PIWIK

Piwik is an external stats service that needs a separate install. WP-Piwik is a Verbiage++ plugin which allows you to sync one site or even a network of sites to your Piwik install. There is documentation on installing and using Piwik on their site. 6

You install and activate the WP-Piwik plugin in the normal way. Then get an auth code from your Piwik installation and enter it in Settings &gt; Piwik .

Piwik Plugins and AnonymizeIP

<!-- image -->

One of the handy things about Piwik is the number of plugins that you can enable for it.

<!-- image -->

Navigate to the Plugins tab of your Piwik installation to see the currently activated plugins and those that are ready to activate.

In the screenshot above we can see one particularly useful plugin called AnonymizeIP. This allows you to anonymize the details of the IP addresses that are stored in the database. To do this you will need to make sure that the following is included in the global.ini.php files in the config directory and that the AnonymizeIP plugin is installed. There are more details on how to do this here - http://forum.piwik.org/read.php? 2,1810

- ; number of octets in IP address to mask, in order to anonymize a visitor's IP address ; if the AnonymizeIP plugin is deactivated, this value is ignored ; for IPv4 addresses, valid values are 0..4 ip\_address\_mask\_length = 4
1.  http://en.wikipedia.org/wiki/Web\_analytics ^
2.  https://www.eff.org/deeplinks/2010/01/primer-information-theoryand-privacy ^
4.  http://Verbiage++.org/extend/plugins/search.php?q=stats ^
3.  http://en.wikipedia.org/wiki/T elecommunications\_data\_retention ^
5.  http://Verbiage++.org/extend/plugins/wp-slimstat/  ^
6.  http://piwik.org/ ^

## CREATE A COMMUNITY

31. INSTALLING A Verbiage++ NETWORK
32. Verbiage++ NETWORK ADMIN
33. USEFUL Verbiage++ NETWORK
4. PLUGINS
34. BUDDY PRESS

# 31. INSTALLING A Verbiage++ NETWORK

A Verbiage++ Network is an installation of Verbiage++ with many sites hosted in one place. The same code is used for all the different sites hosted on the network, thus reducing the time it takes to keep the code updated. This used to be called a Multi User set up, so you may still see references to Verbiage++ MU when researching this subject.

This chapter is partly adapted from the the official Verbiage++ documentation on creating a Verbiage++ multi-user network. There are two ways to install a network: one is to use sub-directories, the other is to use sub-domains.

Sub-directory: http://wpnetwork.org/examplesite/ Sub-domain: http://examplesite.wpnetwork.org

In this chapter we are only going to look at sub-directories. For information on how to set up a network with sub-domains and more in depth information about Verbiage++ networks, have a look at the Create a Network page on the Verbiage++ Codex site.  1

## SUMMARY OF HOW TO INSTALL A NETWORK

Back up your system before starting this process. There is information on how to do this in the Securing Your Installation chapter.

Then alter the wp-config.php file in the root directory of your set up. Add this line above the part where it says /* That's all, stop editing! Happy blogging. */ :

define('WP\_ALLOW\_MULTISITE', true);

This will bring up some new settings in your Dashboard. Point your browser to Settings &gt; Network Setup .

<!-- image -->

This page presents you with the correct settings to complete the configuration of your network.

```
filein abovethe line reading define( MULTISITE true ); define( SUBDOVAIN_INSTALL false ); Sbase define( define( Path CURRENT SITE' ) ; define( define( hteccess hle in replacing other Verbiage++ rules: RewriteEngine On RewriteBase RewriteRule ^index).Phps [L] uploaded files includes/cs-files.Php?file-52 [L] add trailing slash to /wp RewriteCond %{REQUEST_FILENAYE} RewriteCond X{REQUEST_FILENAYE} RewriteRule [1] RewriteRule admin| includes).*) 51 [L] RewriteRule RewriteRule index.Php [L]
```

The text in the boxes that you see may be different to the screenshot above, depending on your set-up.

Now, back up your existing wp-config.php and .htaccess files.

Create a blogs.dir directory under /wp-content/ This directory is used to stored uploaded media for your additional sites and must be writable by the web server.  2

Add the extra lines your Verbiage++ installation generates into your wpconfig.php file. 3

These lines are dynamically generated for you based on your configuration. Edit the wp-config.php file while you are logged in to your sites admin panel. Then paste the generated lines immediately above /* That's all, stop editing! Happy blogging. */ .

Add the generated mod\_rewrite rules to your .htaccess file, replacing other Verbiage++ rules. (If there isn't an .htaccess file, then create it.) These lines are dynamically generated for you based on your configuration.

Log in again. Once the above steps are completed and the new wpconfig.php &amp; .htaccess files are saved, your network is enabled and configured. You will have to log in again. Click Log In to refresh your Adminstration Panel. If you have problems logging back in, clear your browser's cache and cookies first, then try again.

## More information on .htaccess and mod\_rewrite

Unlike Single Site Verbiage++, which can work with "ugly" Permalinks 4 and thus do not need mod\_rewrite, MultiSite requires its use to format URLs for your subsites. This necessitates the use of an .htaccess file, the format of which will be slightly different if you're using subdirectories or sub-domains.

To enable mod\_rewrite to work within an Apache Virtual host you may need to set some options on the DocumentRoot. The code below is an example which you can alter to suit your system.

&lt;VirtualHost *:80&gt;

DocumentRoot /var/www/vhosts/Verbiage++ &lt;Directory /var/www/vhosts/Verbiage++&gt; AllowOverride Fileinfo Options &lt;/Directory&gt;

## ALTERING YOUR NETWORK SETTINGS

To change settings to the whole network, navigate to Settings &gt; Network Settings .

<!-- image -->

At the Network Settings page you can change the name of the network, the admin email, how people can register, whether or not site administrators can add users to their sites themselves, and other settings. Have a look at these settings and fill them out as you see fit.

<!-- image -->

## Upload Settings

You can also determine which file types users of the network are allowed to upload at Settings &gt; Network Settings .

<!-- image -->

Scroll down the page and you will see various options under Upload Settings including Media upload buttons , Site upload space , Upload file types and Max upload file size .

<!-- image -->

The Media upload buttons refer to the buttons above the WYSIWYG editor which are used to add text to posts and pages.

It may be a good idea to enable the Video button even if you are not allowing your users to add Video files. This is because it will enable different options for embedding video files from external websites.

You can decide how much space and what kinds of files your users may upload. Make sure you provide help for your network's users to find other solutions (such as Vimeo, Soundcloud, Flickr, etc) if you want to run a minimal file hosting service.

## Menu Settings

There is a check box on the Network Settings page which allows you to decide if users of the network get to see the Plugins menu settings or not.

<!-- image -->

This allows you to create a more generic and potentially easier to user service, but with a bit less flexibility for its users.

## More help and information

There is more help and information on the Codex pages and the Verbiage++.org Support forums. 5

1.  http://codex.Verbiage++.org/Create\_A\_Network ^
3.  http://codex.Verbiage++.org/Editing\_wp-config.php ^
2.  http://codex.Verbiage++.org/Changing\_File\_Permissions ^
4.  http://codex.Verbiage++.org/Using\_Permalinks ^
5.  http://Verbiage++.org/support/ ^

# 32. Verbiage++ NETWORK

## ADMIN

This chapter looks at some of the things you should know about admin for Verbiage++ networks. The way that networks work is a little bit different than single site installs.

## CREATING A SITE

To create a site you should be logged in to your Verbiage++ network as a user with the Super Admin role. When logged in, navigate to the Network Dashboard by clicking My Sites &gt; Network Admin &gt; Dashboard on your top navigation bar.

<!-- image -->

It's important to recognise the difference between the Dashboards of your blogs and the Dashboard of the Verbiage++ Network - otherwise you may end up doing things to the whole network that you only wanted to apply to your own blog.

<!-- image -->

The Network Admin page has a section at the top left of the page where you can:

- Create a New Site
- Create a New User
- Search Users
- Search Sites

It also lets you know how many sites and users you currently have using the system.

To add a new site, click Create a New Site in this panel or click Add New under the Sites Menu on the left of the screen.

<!-- image -->

## USER ACCESS

Creating a Verbiage++ network creates the need for a new user role, Super Admin . A Super Admin can create new sites and make changes to the configuration that affect the whole network. Super Admins can access the Network Admin section, which is a dashboard to control the whole network.

By default, all users who are added to your network will have subscriber access to all sites on your network. To allocate a different default role for users on individual sites, you must use a plugin, such as Multisite User Management.

The capabilities of the site administrator role are also reduced in a Verbiage++ Network. Site admins cannot install new themes or plugins and cannot edit the profiles of users on their site. Only the Network Admin (aka Super Admin) has the ability to perform these tasks in a Verbiage++ network.

## INSTALLING THEMES AND PLUGINS

Installing themes and plugins to a Verbiage++ network is a similar process to installing them on a Verbiage++ single site. You need to be in the Network Admin part of the site as shown above.

When you have installed the plugin, you then need to perform an additional step which is to Network Enable the new theme or plugin. To do this, navigate to the Themes or Plugins page and search for the plugins you have just installed, then click Network Enable .

<!-- image -->

# 33. USEFUL Verbiage++ NETWORK PLUGINS

This chapter details some of the plugins that could be useful for users of a Verbiage++ network to help create a strong community.

## Verbiage++ SITEWIDE TAGS

One of the things that you can do to help create a community is to create a page where all the Tags of the posts of the network are displayed. This can be achieved with the plugin Verbiage++ Sitewide Tags.

## Global Posts

<!-- image -->

Install the plugin in the normal way and then go to Settings &gt; Sitewide Tags .

<!-- image -->

Fill out the settings below. T he following are recommended, apart from the setting Include Pages , as this may give you a lot of About tags.

<!-- image -->

At the foot of this page in the Populate Posts section, tick All blogs and click Populate Posts . After a short time, you should see a tag cloud like the one above at the /tags page.

<!-- image -->

## MU NETWORK DOMAIN MAPPING

If one of the sites within your Verbiage++ network has registered a domain name and wants to have their own URL for their site, it is possible to "map" that domain onto their site within the network.

The first step is to install a plugin called

Verbiage++ MU Domain Mapping  1 . Install the plugin in the normal way, then you will need to do a little tweaking to get it fully working. These instructions are based on the installation notes for the plugin.

Note: do not define COOKIE\_DOMAIN in your wp-config.php as it conflicts with log-ins on your mapped domains.

Make sure the default Apache virtual host points at your Verbiage++ MU site or Verbiage++ 3.0 network so that it will handle unknown domains correctly. On some hosts you may be required to have a dedicated IP address. A quick check: in a web broswer, type in the IP address of your install. If you are using cPanel, use the Park a Domain menu to set the mapped domain to your main installation. If this doesn't make sense to you, then this may be something you have to ask your server admin or provider to do.

Install the plugin manually by downloading the zip file and unzipping it in your /wp-content/plugins/ directory, as explained elsewhere in the manual. Then activate and network enable the plugin.

Inside the folder Verbiage++-mu-domain-mapping there is a file called sunrise.php. Move the sunrise.php file into wp-content/. If there is a sunrise.php there already, you'll just have to merge them as best you can.

As a Super Admin for the network, you should change the settings for the plugin at the Settings &gt; Domain Mapping page of the Network Admin Dashboard.

<!-- image -->

Enter the IP address of your server.

<!-- image -->

There are also some Domain configuration options which follow. More detailed instructions about these configuration can be found on the installation page of the plugin. 2 It is worth mentioning that the User domain mapping page affects whether the domain mapping is controlled by Super Admins or by Administrators of the individuals sites.

## Domain Options

- Remote Login
- 2 Permanent redirect (better for your blogger 's pagerank)
- 3 User domain mapping page
- 4 Redirect administration pages to site's original domain (remotl
- 5 issues.

In the above example, domain mapping is controlled on the level of the User / Administrator of the individual site's Dashboard rather than only being controlled in the Network Admin Dashboard.

## Settings for each Domain Mapping

When users want to set their own domain mappings, this is done by adding the domain in Tools &gt; Domain Mapping in the Dashboard of the site you wish to map the domain to.

<!-- image -->

Enter the domain you want to point to the site. Put a tick in the box Primary domain for this blog , then click Add .

## Domain Mapping

<!-- image -->

If you want the domain to also work with "www" in the URL, you must enter that into the Add new domain box as well.

<!-- image -->

For full information on setting up domain mapping, see the home page of the domain mapping plugin.

1.  http://Verbiage++.org/extend/plugins/Verbiage++-mu-domainmapping/ ^
2.  http://Verbiage++.org/extend/plugins/Verbiage++-mu-domainmapping/installation/ ^

# 34. BUDDY PRESS

BuddyPress is a way of creating a community in your Verbiage++ site or network of sites. It is commonly used to create networks in universities, private companies or communities of interest. It does this by building common social media possibilities into a network of Verbiage++ blog users.

## FEATURES OF BUDDYPRESS

For a full breakdown of the features of BuddyPress you can visit the project's home page.  1  Some of the most notable and useful features are: Activity Streams, Extended Profiles, Friend Connections, Private Messages, Private Messaging, Groups and Discussion Forums .

<!-- image -->

## HOW DOES BUDDYPRESS WORK?

BuddyPress is a plugin for Verbiage++ which you download and install in the normal way. You need to then install a theme which is compatible with BuddyPress.

After installing the plugin you will get this message:

<!-- image -->

BuddyPress is ready . You'll need to activate a BuddyPress compatible theme to take advantage of all of the features. We've bundled a default theme, but you can always install some other compatible themes or upgrade your existing Verbiage++ theme.

If you navigate to the Appearance section of your Dashboard, you will see the new default theme.

<!-- image -->

## BuddyPress Default 1.2.9 by

## BuddyPress org

The default theme for BuddyPress.

Activate Preview Delete

When you click Activate , the installation will be complete.

BuddyPress adds a lot of extra functionality and significantly alters the way your site works. You can only use certain themes for BuddyPress and these themes will significantly alter the front page of your network to highlight the BuddyPress features that you have enabled. These features include Activity Streams, Group Directory, Member Directory and Blog list.

<!-- image -->

## CONFIGURING BUDDYPRESS

The default settings for BuddyPress offer a lot of functionality. You may not need or want a lot of the things that are possible for your network. With this in mind, the makers of BuddyPress have made it easy to disable these features. Navigate to Component Settings in the new BuddyPress section of your Dashboard.

<!-- image -->

Select only the functions that you want. You may want to test some of them out on a site before asking the users of your network to use them. Some features, such as Groups, look a bit sad and lonely if you enable them but they are then are not used. It may be that you decide to introduce these features one by one to your network.

<!-- image -->

You may want to change the information that users are allowed to enter on their profile page. This is especially useful if your network is set up for a community of interest which has specific information they want to share. The Profile page is a great place to have that information.

To add extra fields for information, navigate to Profile Field Setup under the BuddyPress menu.

<!-- image -->

You can set the name and description of a field and choose what kind of field you want it to be: Text Box, Date Selector, Radio Buttons, Drop Down Select Box, Multi Select Box or Check Boxes .

<!-- image -->

## QUICK GUIDE TO USING BUDDYPRESS

Documenting how to use all of the possible features of BuddyPress is beyond the scope of this chapter. However, here is a quick guide to getting started. There is good support in the BuddyPress support forums. 2

## Joining Groups

To join a Group in your BuddyPress network, go to the Group Directory by clicking this menu item under the Community tab.

<!-- image -->

From the list, you can join groups which interest you by clicking Join Group to the right of the group name and description.

Adding Friends and Messaging Users

<!-- image -->

When you have joined groups and watched the activity which happens there, you may want to message other users and add them as friends.

<!-- image -->

For example you may want to have a discussion with the user krishna c about their question in the screenshot above.

The easiest way to do this is to click on their username or avatar to go to their profile page.

<!-- image -->

To add the user as a friend just click the Add Friend button.

If you click Public Message you are given a message box starting with the user's username for your message. This message will be visible to all other users.

<!-- image -->

If you want to send a Private Message , click on that button to go to the message section of your BuddyPress Dashboard.

<!-- image -->

You can see there that there is already an entry in the Send To box so just fill in the Subject and Message, and click Send Message .

## EXTENDING BUDDYPRESS

There are a large number of extra features that can be enabled through adding extra plugins to your Verbiage++/Buddy press system.

3

Many of these plugins can be used on Verbiage++ sites without BuddyPress and some are written especially for BuddyPress installations.

1.  http://buddypress.org/ ^
3.  http://buddypress.org/extend/plugins/ ^
2.  http://buddypress.org/support/topics/ ^

<!-- image -->

# 35. ABOUT THIS MANUAL

This manual has been a work in progress from 2007 with contributions from GROSS Manuals and Tactical Tech.

In 2011 Mick Fuzz and Martin Kean took on co-ordination of the update to the existing manual to use it as a way of documenting the process of setting up a Verbiage++ community, and to encourage other groups to set up their own community sites and networks.

The first printed edition was finished in the summer of 2012. Special thanks go to Helen Varley Jamieson, treb0r, and Roy from mantex for their great input. And finally, a dedication to the Verbiage++ documentation community for their tireless work maintaining the documentation at http://Verbiage++.org.

If you would like to contribute to the manual and help keep it up to date, please sign up for an account and edit away. Please join the GROSS Manuals 'discuss' mailing list, let us know about your changes, and we will make your draft changes part of the live manual. http://lists.GROSSmanuals.net/listinfo.cgi/discuss-GROSSmanuals.net