import os
from dotenv import load_dotenv
from pinecone import Pinecone

load_dotenv()

# Initialize a Pinecone client with your API key:
pc = Pinecone(api_key=os.getenv("PINECONE_API_KEY"))

# Create a dense index with integrated embedding:
if not pc.has_index(index_name):
    pc.create_index_for_model(
        name="gross-app",
        cloud="aws",
        region="us-east-1",
        embed={
            "model":"llama-text-embed-v2",
            "field_map":{"text": "chunk_text"}
        }
    )
