#---
# Excerpted from "Programming Ruby 3.2",
# published by The Pragmatic Bookshelf.
# Copyrights apply to this code. It may not be used to create training material,
# courses, books, articles, and the like. Contact us if you are in doubt.
# We make no guarantees that this code is fit for any purpose.
# Visit https://pragprog.com/titles/ruby6 for more book information.
#---
require "concurrent-ruby"
require "yaml"

class Book
  include Concurrent::Async
  attr_reader :file_name, :data

  def initialize(file_name)
    @file_name = file_name
  end

  def load
    @data = async.load_data
  end

  def load_data
    YAML.safe_load_file("./code/tut_threads/data/#{file_name}")
  end

  def price = Float(data.value["price"])

  def in_stock = Integer(data.value["in_stock"])

  def inventory = price * in_stock
end

books = Dir.children("./code/tut_threads/data").sort.map { Book.new(it) }
books.each { it.load }

puts books.sum { it.inventory }
