#---
# Excerpted from "Programming Ruby 3.2",
# published by The Pragmatic Bookshelf.
# Copyrights apply to this code. It may not be used to create training material,
# courses, books, articles, and the like. Contact us if you are in doubt.
# We make no guarantees that this code is fit for any purpose.
# Visit https://pragprog.com/titles/ruby6 for more book information.
#---
require "net/http"

pages = %w[www.rubycentral.org www.ruby-lang.org www.google.com]

threads = pages.map do |page_to_fetch|
  Thread.new(page_to_fetch) do |url|
    http = Net::HTTP.new(url)
    print "Fetching: #{url}\n"
    response = http.get("/")
    print "Got #{url}:  #{response.message}\n"
  end
end
threads.each { it.join }
print "We're done here!\n"
