;---
; Excerpted from "Programming Clojure, Fourth Edition",
; published by The Pragmatic Bookshelf.
; Copyrights apply to this code. It may not be used to create training material,
; courses, books, articles, and the like. Contact us if you are in doubt.
; We make no guarantees that this code is fit for any purpose.
; Visit https://pragprog.com/titles/shcloj4 for more book information.
;---
(ns examples.multimethods.account)

(defmulti interest-rate :tag)
(defmethod interest-rate ::checking [_] 0M)
(defmethod interest-rate ::savings  [_] 0.05M)

(defmulti account-level :tag)
(defmethod account-level ::checking [acct]
  (if (>= (:balance acct) 5000) ::premium ::basic))
(defmethod account-level ::savings [acct]
  (if (>= (:balance acct) 1000) ::premium ::basic))

